<?php

use Illuminate\Support\Facades\Broadcast;

Broadcast::channel('App.Models.User.{id}', function ($user, $id) {
    return (int) $user->id === (int) $id;
});



// قناة خاصة للمحادثات
Broadcast::channel('chat.{chatId}', function ($user, $chatId) {
    // تحقق من أن المستخدم جزء من المحادثة
    return $user->chats()->where('id', $chatId)->exists();
});

// قناة خاصة للإشعارات
Broadcast::channel('notifications.{userId}', function ($user, $userId) {
    // تحقق من أن المستخدم هو نفسه المستخدم الذي يتلقى الإشعارات
    return (int) $user->id === (int) $userId;
});

// قناة خاصة للمجموعات
Broadcast::channel('group.{groupId}', function ($user, $groupId) {
    // تحقق من أن المستخدم جزء من المجموعة
    return $user->groups()->where('id', $groupId)->exists();
});

// قناة خاصة للفعاليات
Broadcast::channel('events.{eventId}', function ($user, $eventId) {
    // تحقق من أن المستخدم مسجل في الفعالية
    return $user->events()->where('id', $eventId)->exists();
});
