<?php

use Illuminate\Support\Facades\Password;
use Livewire\Attributes\Layout;
use Livewire\Volt\Component;
use Illuminate\View\View;

new #[Layout('components.frontend.layouts.struct')] class extends Component {

public function rendering(View $view): void
    {
        $view->title(__('frontend.tittlewelcomepage')  . ' | ' . __('frontend.forgot_title'));
    }
    public string $email = '';

    /**
     * Send a password reset link to the provided email address.
     */
    public function sendPasswordResetLink(): void
    {
        $this->validate([
            'email' => ['required', 'string', 'email'],
        ]);

        Password::sendResetLink($this->only('email'));

        session()->flash('status', __('A reset link will be sent if the account exists.'));
    }
}; ?>

<div class="min-h-screen flex items-center justify-center bg-transparent transition duration-700 overflow-hidden relative">

    <div class="z-10 max-w-md w-full space-y-6 bg-white/80 dark:bg-zinc-900/80 backdrop-blur-md p-8 rounded-xl shadow-2xl border border-zinc-300 dark:border-zinc-700">
        <!-- 🔵 Logo + عنوان -->
        <div class="flex flex-col items-center gap-2 animate-fade-in-down">
            <img src="/assets/img/logo.png" alt="Logo" class="w-[300px] h-auto mb-3 drop-shadow-lg" />
            <h2 class="text-2xl font-semibold text-zinc-800 dark:text-white">
                {{ __('frontend.forgot_title') }}
            </h2>
            <p class="text-sm text-zinc-500 dark:text-zinc-400 text-center">
                {{ __('frontend.forgot_desc') }}
            </p>
        </div>



        <!-- 📨 نموذج الإرسال -->
        <form wire:submit="sendPasswordResetLink" class="space-y-4 animate-fade-in-down">
            <div>
                <label for="email" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300">
                    {{ __('frontend.emailadress') }}
                </label>
                <input type="email" id="email" wire:model="email" required autofocus
                       class="mt-1 block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 ring-accent outline-none transition"
                       placeholder="email@example.com" />
            </div>

            <button type="submit"
                    class="neon-btn neon-blue w-full delay-[500ms]">
                <span class="btn-text">{{ __('frontend.send_reset_link') }}</span>
                <span class="glow"></span>
            </button>
        </form>

        <!-- 🔁 العودة لتسجيل الدخول -->
        <div class="text-center mt-4 animate-fade-in-down">
            <p class="text-sm text-zinc-600 dark:text-zinc-300">
                {{ __('frontend.backtologin') }}
                <a href="{{ route('login') }}" class="text-blue-500 hover:underline">{{ __('frontend.login') }}</a>
            </p>
        </div>
    </div>
</div>

