<div wire:ignore.self x-data="{
    show: true,
    pages: @entangle('selectedUser.pages.page'),
    elements: @entangle('selectedUser.pages.element'),
    allRoutes: [],
    selectedPage: null,


    // حالة إذا كانت كل الصفحات مختارة
    allSelected: false,
    allElementsSelected: false,




    initElements() {
        this.updateAllElementsSelected()
    },


    toggleAllElements() {
        const page = this.selectedPage;
        const pageObj = this.allRoutes.find(r => r.name === page);
        if (!pageObj) return;

        if (this.allElementsSelected) {
            // لو فعلاً كل العناصر كانت محددة، نمسحها
            this.elements[page] = [];
            // ونشيل الصفحة من المصفوفة إذا ما في عناصر
            this.pages = this.pages.filter(p => p !== page);
        } else {
            // نعبيها كلها
            this.elements[page] = [...pageObj.elements];
            // ونتأكد إن اسم الصفحة موجود في pages
            if (!this.pages.includes(page)) {
                this.pages.push(page);
            }
        }

        this.updateAllElementsSelected();
    },

    // يحدث حالة allElementsSelected
    updateAllElementsSelected() {
        const page = this.selectedPage
        const pageObj = this.allRoutes.find(r => r.name === page)
        if (!pageObj) {
            this.allElementsSelected = false
            return
        }
        const allElems = pageObj.elements || []
        const selElems = this.elements[page] || []
        // إذا طول المصفوفتين متساوي وكل العناصر موجودة
        this.allElementsSelected = allElems.length > 0 && allElems.every(e => selElems.includes(e))
    },

    loadRoutes() {
        $wire.call('fetchRoutes').then(r => {
            this.allRoutes = r;
            // إذا كانت القيمة المحمّلة من الباك تحتوي على '[all]'، فعنصر allSelected = true
            this.allSelected = this.pages.includes('[all]');
            this.initElements();
        });
    },

    init() {
        this.selectedPage = this.pages[0] !== '[all]' ? this.pages[0] : null;
        this.initElements();
        // كل ما تتغيّر الصفحة المختارة، حدّث حالة allElementsSelected
        this.$watch('selectedPage', () => {
            this.updateAllElementsSelected();
        });
    },


    // تبديل تحديد كل الصفحات
    toggleAllPages() {
        if (this.allSelected) {
            // إعادة الوضع الافتراضي
            this.pages = [];
            this.elements = {};
            this.selectedPage = null;
            this.allSelected = false;
            this.allElementsSelected = false;
        } else {
            // تفعيل all
            this.pages = ['[all]'];
            this.allSelected = true;
            // نعيّن أول صفحة علشان تظهر قائمة العناصر
            this.selectedPage = this.allRoutes[0]?.name || null;
            // نملأ عناصر كل صفحة بكل مفاتيحها
            this.elements = this.allRoutes.reduce((acc, route) => {
                acc[route.name] = [...(route.elements || [])];
                return acc;
            }, {});
            // نعَدّل حالة allElementsSelected
            this.updateAllElementsSelected();
        }
    },


    togglePage(pageName) {
        if (this.allSelected) {
            this.pages = [];
            this.allSelected = false;
        }

        if (this.pages.includes(pageName)) {
            this.pages = this.pages.filter(p => p !== pageName);
            delete this.elements[pageName];
            this.selectedPage = null;
        } else {
            this.pages.push(pageName);
            this.elements[pageName] = [];
            this.selectedPage = pageName;
        }

        // بعد تبديل الصفحة حدّث حالة toggle-all-elements
        this.updateAllElementsSelected();
    },


    // تبديل عنصر
    toggleElement(pageName, elementName) {
        if (!this.elements[pageName]) this.elements[pageName] = [];
        if (this.elements[pageName].includes(elementName)) {
            this.elements[pageName] = this.elements[pageName].filter(e => e !== elementName);
        } else {
            this.elements[pageName].push(elementName);
        }
    },

    // حفظ الصلاحيات
    savePrivileges() {
        // إذا الزر “تحديد الكل” مفعل، أرسل حرفيًّا الـ placeholder
        const pagesToSet = this.allSelected ? ['[all]'] : this.pages;
        const elementsToSet = this.allSelected ? {} : this.elements;

        $wire.set('selectedUser.pages.page', pagesToSet);
        $wire.set('selectedUser.pages.element', elementsToSet);
        $wire.updatePrivileges();
    },

    // إغلاق المودال
    closeModal() {
        this.show = false;
        $wire.closeModal();
    }
}" x-init="elementLabels = @js(__('backend.elements'));
loadRoutes(), init()" x-cloak x-show="show"
    @keydown.escape.window="closeModal()" @click.away="closeModal()"
    class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 px-4 sm:px-6 lg:px-8">
    <div
        class="bg-white dark:bg-zinc-900 rounded-xl shadow-2xl border border-zinc-200 dark:border-zinc-700 w-full max-w-4xl p-6 space-y-6 transition-all duration-300 overflow-y-auto max-h-[90vh]">

        <!-- Header -->
        <div class="flex justify-between items-center mb-4">
            <div>
                <h3 class="text-xl font-bold text-zinc-800 dark:text-white mb-1">
                    {{ __('backend.user_privileges') }}
                </h3>
                <p class="text-sm text-zinc-600 dark:text-zinc-400">
                    {{ __('backend.name') }}:
                    {{ $selectedUser2['employee']['full_name_translated'] ?? '-' }}
                </p>

                <p class="text-sm text-zinc-600 dark:text-zinc-400">
                    {{ __('backend.employee_code') }}:
                    {{ $selectedUser['employee']['employee_code'] ?? '-' }}
                </p>
            </div>

            <button @click="closeModal()"
                class="text-zinc-500 hover:text-zinc-800 dark:hover:text-white text-2xl leading-none">
                &times;
            </button>
        </div>


        <!-- Main Content: 2 columns -->
        <div class="flex gap-6">

            <!-- Left Column: Pages -->
            <div class="w-1/3 border-r border-zinc-300 dark:border-zinc-600 pr-4">
                <!-- داخل العمود الأيسر قبل عنوان الصفحات -->
                <button @click="toggleAllPages()"
                    :class="{
                        'bg-green-600 text-white hover:bg-green-700': !allSelected,
                        'bg-red-600 text-white hover:bg-red-700': allSelected
                    }"
                    class="w-full text-sm font-medium py-2 rounded mb-4 transition">
                    <span x-text="allSelected ? '{{ __('backend.unselect_all') }}' : '{{ __('backend.select_all') }}'"></span>
                </button>

                <h4 class="font-semibold mb-2 text-zinc-700 dark:text-white">{{ __('backend.pages') }}</h4>
                <template x-for="route in allRoutes" :key="route.name">
                    <div @click="selectedPage = route.name"
                        :class="{
                            'bg-blue-100 text-blue-800 dark:bg-blue-800 dark:text-white': selectedPage === route.name,
                            'cursor-pointer p-2 rounded mb-2 transition': true
                        }">
                        <div class="flex items-center space-x-2">
                            <input type="checkbox" :checked="allSelected || pages.includes(route.name)"
                                :disabled="allSelected" @click.stop="togglePage(route.name)"
                                class="form-checkbox h-4 w-4 text-blue-600" />
                            <label :class="{ 'opacity-50 cursor-not-allowed': allSelected }"
                                class="flex items-center space-x-2">
                                <span x-text="route.display_name"></span>
                            </label>

                        </div>
                    </div>
                </template>

            </div>

            <!-- Right Column: Elements -->
            <div class="flex-1">
                <div x-show="selectedPage" class="mb-4">
                    <button @click="toggleAllElements()" :disabled="allSelected"
                        :class="{
                            'opacity-50 cursor-not-allowed bg-gray-300 text-gray-600': allSelected,

                            'bg-green-600 text-white hover:bg-green-700': !allSelected && !allElementsSelected,
                            'bg-red-600 text-white hover:bg-red-700': !allSelected && allElementsSelected
                        }"
                        class="px-3 py-1 rounded text-sm transition">
                        <span x-text="allElementsSelected ? '{{ __('backend.unselect_all_elements') }}' : '{{ __('backend.select_all_elements') }}'"></span>
                    </button>
                </div>

                <h4 class="font-semibold mb-2 text-zinc-700 dark:text-white">
                    {{ __('backend.elements_title') }}
                </h4>
                <template x-if="selectedPage">
                    <template x-if="allRoutes.find(r => r.name === selectedPage)?.elements.length > 0">

                        <div class="flex flex-wrap gap-3">
                            <template x-for="key in allRoutes.find(r => r.name === selectedPage)?.elements"
                                :key="key">
                                <label
                                    :class="{
                                        'opacity-50 cursor-not-allowed': allSelected,
                                        'bg-zinc-100 dark:bg-zinc-800': !allSelected
                                    }"
                                    class="relative flex items-center space-x-2 text-sm px-3 py-2 rounded transition">
                                    <input type="checkbox"
                                        :checked="allSelected || elements[selectedPage]?.includes(key)"
                                        :disabled="allSelected" @change="toggleElement(selectedPage, key)"
                                        class="form-checkbox h-4 w-4 text-indigo-600" />
                                    <span x-text="window.elementLabels[key] ?? key"></span>

                                    <!-- أيقونة الصح حتى لو disabled -->
                                    <svg x-show="allSelected || elements[selectedPage]?.includes(key)"
                                        xmlns="http://www.w3.org/2000/svg"
                                        class="absolute inset-y-0 right-2 h-4 w-4 text-green-600" viewBox="0 0 20 20"
                                        fill="currentColor">
                                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 00-1.414 0L8 12.586
                                             5.707 10.293a1 1 0 00-1.414 1.414l3 3a1
                                             1 0 001.414 0l8-8a1 1 0 000-1.414z" clip-rule="evenodd" />
                                    </svg>
                                </label>
                            </template>

                        </div>
                    </template>

                    <template x-if="allRoutes.find(r => r.name === selectedPage)?.elements.length === 0">
                        <p class="text-sm text-zinc-500">{{ __('backend.no_elements_for_page') }}</p>
                    </template>
                </template>

                <template x-if="!selectedPage">
                    <p class="text-sm text-zinc-500">{{ __('backend.select_page_to_view_elements') }}</p>
                </template>
            </div>

        </div>

        <!-- Footer -->
        <div class="flex justify-end space-x-2 rtl:space-x-reverse mt-6">
            <button @click="closeModal()"
                class="px-4 py-2 rounded-lg text-sm bg-zinc-200 dark:bg-zinc-700 hover:bg-zinc-300 dark:hover:bg-zinc-600 text-zinc-800 dark:text-white">
                {{ __('frontend.close') }}
            </button>
            <button @click="savePrivileges()"
                class="px-4 py-2 rounded-lg text-sm bg-green-600 text-white hover:bg-green-700">
                {{ __('backend.save') }}
            </button>
        </div>

    </div>
</div>
