<!-- livewire/backend/user/modals/edit.blade.php -->

<div x-data="{ show: true }" x-show="show" x-transition:enter="transition ease-out duration-300"
    x-transition:enter-start="opacity-0 scale-90" x-transition:enter-end="opacity-100 scale-100"
    x-transition:leave="transition ease-in duration-200" x-transition:leave-start="opacity-100 scale-100"
    x-transition:leave-end="opacity-0 scale-90" @click.away="$wire.closeModal()"
    class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 px-4 sm:px-6 lg:px-8">

    <div
        class="bg-white dark:bg-zinc-900 rounded-xl shadow-2xl border border-zinc-200 dark:border-zinc-700 w-full max-w-lg p-6 space-y-6 transition-all duration-300 overflow-y-auto max-h-[90vh]">

        <!-- Header -->
        <div class="flex justify-between items-center">
            <h3 class="text-xl font-bold text-zinc-800 dark:text-white">
                {{ __('backend.add_new_user') }}
            </h3>
            <button @click="show = false; $wire.closeModal()"
                class="text-zinc-500 hover:text-zinc-800 dark:hover:text-white text-2xl leading-none">
                &times;
            </button>
        </div>

        <!-- Form -->
        <form wire:submit.prevent="updateUser" class="space-y-4">

            <!-- Name -->
            <div>
                <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                    {{ __('backend.name') }}
                </label>
                <input type="text" wire:model.defer="edit.name"
                    class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition" />
            </div>
            <!-- Name AR -->
            <div>
                <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                    {{ __('backend.name') }} (عربي)
                </label>
                <input type="text" wire:model.defer="edit.name_ar"
                    class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition" />
            </div>
            <!-- Email -->
            <div>
                <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                    {{ __('frontend.emailadress') }}
                </label>
                <input type="email" wire:model.defer="edit.email"
                    class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition" />
            </div>

            <!-- Phone -->
            <div x-data="{
                phones: @entangle('edit.phone'),
                addPhone() {
                    this.phones.push('');
                },
                removePhone(index) {
                    if (this.phones.length > 1) {
                        this.phones.splice(index, 1);
                    }
                }
            }">
                <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                    {{ __('frontend.phone') }}
                </label>

                <template x-for="(phone, index) in phones" :key="index">
                    <div class="flex items-center gap-2 mb-2">
                        <div
                            class="flex items-center gap-2 px-3 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 flex-1">
                            <!-- Prefix -->
                            <svg class="w-5 h-5 text-indigo-500 dark:text-indigo-400" fill="none"
                                stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round"
                                stroke-linejoin="round">
                                <path
                                    d="M22 16.92V21a2 2 0 0 1-2.18 2A19.79 19.79 0 0 1 3 5.18 2 2 0 0 1 5 3h4.09a1 1 0 0 1 1 .75l1.21 4.84a1 1 0 0 1-.29 1L9.1 11.1a16 16 0 0 0 6.9 6.9l1.51-1.51a1 1 0 0 1 1-.29l4.84 1.21a1 1 0 0 1 .75 1z" />
                            </svg>
                            <span class="text-sm font-medium select-none">+20</span>
                            <input type="tel" :id="'phone_' + index" placeholder="10xxxxxxxx"
                                class="flex-1 px-2 py-1 bg-transparent outline-none text-zinc-900 dark:text-white"
                                x-model="phones[index]" />
                        </div>

                        <!-- زر الحذف -->
                        <button type="button" @click="removePhone(index)"
                            class="text-red-500 hover:text-red-700 text-lg font-bold px-2 py-1">
                            &times;
                        </button>
                    </div>
                </template>

                <!-- زر إضافة رقم -->
                <div class="flex justify-center mt-2">
                    <button type="button" @click="addPhone()"
                        class="px-3 py-1 bg-indigo-600 text-white text-sm rounded hover:bg-indigo-700 transition">
                        + {{ __('frontend.add_phone') }}
                    </button>
                </div>

                <p class="mt-1 text-xs text-zinc-500 dark:text-zinc-400">
                    {{ __('frontend.phone_hint') }}
                </p>
            </div>

            <!-- National ID -->
            <div>
                <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                    {{ __('frontend.national_id') }}
                </label>
                <input type="text" wire:model.defer="edit.national_id" maxlength="14" placeholder="xxxxxxxxxxxxxx"
                    class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition" />
            </div>



            <!-- Project -->
            <div>
                <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                    {{ __('frontend.project') }}
                </label>
                <select wire:model.defer="edit.project_code"
                    class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition">
                    <option value="">{{ __('frontend.chooseproject') }}</option>
                    @foreach (App\Models\User\UserProject::all() as $project)
                        <option value="{{ $project->code }}">{{ $project->name }}</option>
                    @endforeach
                </select>
            </div>

            <!-- Job Title -->
            <div>
                <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                    {{ __('frontend.job_title') }}
                </label>
                <select wire:model.defer="edit.job_title_id"
                    class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition">
                    <option value="">{{ __('frontend.choosejobtitle') }}</option>
                    @foreach (App\Models\User\UserJobTitle::whereNotIn('id', [0])->get() as $jobTitle)
                        <option value="{{ $jobTitle->id }}">
                            {{ app()->getLocale() == 'ar' ? $jobTitle->title_ar : $jobTitle->title_en }}
                        </option>
                    @endforeach
                </select>
            </div>


            <!-- User State -->
            <div>
                <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                    {{ __('backend.choosestate') }}
                </label>
                <select wire:model.defer="edit.user_state"
                    class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition">
                    @foreach ($userStates as $value => $label)
                        <option value="{{ $value }}">{{ __($label) }}</option>
                    @endforeach
                </select>
            </div>

            <div
                class="mt-3 px-4 py-2 bg-yellow-100 dark:bg-yellow-700 border border-yellow-300 dark:border-yellow-600 text-yellow-800 dark:text-yellow-100 text-center text-sm font-medium rounded-lg shadow-sm">
                {{ __('backend.leave_blank_password_if_no_change') }}
            </div>


            <!-- Password -->
            <div>
                <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                    {{ __('frontend.password') }}
                </label>
                <input type="password" wire:model.defer="edit.password"
                    class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition" />
            </div>

            <!-- Confirm Password -->
            <div>
                <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                    {{ __('frontend.confirmpassword') }}
                </label>
                <input type="password" wire:model.defer="edit.password_confirmation"
                    class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition" />
            </div>

            <!-- Actions -->
            <div class="flex justify-end space-x-2 rtl:space-x-reverse">
                <button type="button" @click="show = false; $wire.closeModal()"
                    class="px-4 py-2 rounded-lg text-sm bg-zinc-200 dark:bg-zinc-700 hover:bg-zinc-300 dark:hover:bg-zinc-600 text-zinc-800 dark:text-white">
                    {{ __('backend.cancel') }}
                </button>
                <button type="submit" class="px-4 py-2 rounded-lg text-sm bg-green-600 text-white hover:bg-green-700">
                    {{ __('backend.save') }}
                </button>
            </div>

        </form>

    </div>
</div>
