<div x-data="{ show: true }" x-show="show" x-transition:enter="transition ease-out duration-300"
    x-transition:enter-start="opacity-0 scale-90" x-transition:enter-end="opacity-100 scale-100"
    x-transition:leave="transition ease-in duration-200" x-transition:leave-start="opacity-100 scale-100"
    x-transition:leave-end="opacity-0 scale-90"
    class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 px-4 sm:px-6 lg:px-8"
    @click.away="show = false; $wire.closeModal()">



    <div
        class="bg-white dark:bg-zinc-900 rounded-xl shadow-2xl border border-zinc-200 dark:border-zinc-700 w-full max-w-3xl p-6 space-y-6 transition-all duration-300 max-h-[80vh] overflow-y-auto relative">

        <!-- Close Button -->
        <button type="button" @click="show = false; $wire.closeModal()"
            class="absolute top-2 ltr:right-2 rtl:left-2 z-50 text-zinc-700 dark:text-white hover:text-red-600 text-3xl font-bold transition"
            title="{{ __('frontend.close') }}">
            &times;
        </button>




        <!-- Header -->
        <div>
            <h3 class="text-2xl font-bold text-zinc-800 dark:text-white">
                {{ __('frontend.edit_cv') }}
            </h3>
            <p class="text-sm text-zinc-500 dark:text-zinc-400 mt-1">
                {{ __('frontend.edit_cv_hint') }}
            </p>
        </div>

        <!-- Progress Bar -->
        <div class="mb-4">
            <div class="flex justify-center items-center space-x-2 rtl:space-x-reverse mb-2">
                <template x-for="step in 3" :key="step">
                    <div class="flex items-center justify-center w-8 h-8 rounded-full border-2 font-semibold transition-all duration-300 text-sm relative"
                        :class="{
                            'bg-indigo-600 text-white border-indigo-600 shadow-lg animate-pulse-step': $wire
                                .cv_currentStep === step,
                            'bg-white text-zinc-700 dark:bg-zinc-800 dark:text-zinc-300 border-zinc-300 dark:border-zinc-600': $wire
                                .cv_currentStep !== step
                        }">
                        <span x-text="step"></span>
                    </div>
                </template>
            </div>

            <div class="w-full bg-zinc-200 rounded-full h-2.5 dark:bg-zinc-700">
                <div class="bg-indigo-600 h-2.5 rounded-full transition-all duration-500"
                    :style="{ width: (($wire.cv_currentStep - 1) / (3 - 1)) * 100 + '%' }">
                </div>
            </div>
        </div>

        <!-- Form -->
        <form wire:submit.prevent="updateCvFull" class="space-y-4 text-sm">

            <!-- Step 1: Profile Picture -->
            <div x-show="$wire.cv_currentStep === 1" x-transition>
                <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-2">
                    {{ __('frontend.upload_profile_picture') }}
                </label>



                <div x-data="{
                    cvPreviewUrl: @js($cv_profile_picture_path ? asset('storage/' . $cv_profile_picture_path) : ''),
                }" class="mt-3">

                    <!-- الصورة -->
                    <img :src="cvPreviewUrl" x-show="cvPreviewUrl.length > 0"
                        class="w-24 h-24 object-cover rounded-full border border-zinc-300 dark:border-zinc-600 mx-auto" />

                    <!-- input رفع صورة -->
                    <input type="file" x-ref="cvProfilePicture" wire:model.live="cv_profile_picture"
                        @change="
                            const file = $refs.cvProfilePicture.files[0];
                            if (file) {
                                cvPreviewUrl = URL.createObjectURL(file);
                            }
                        "
                        class="hidden" accept="image/jpeg,image/png,image/jpg" />

                    <!-- زر الـ Upload -->
                    <div class="flex flex-col items-center justify-center border-2 border-dashed border-zinc-300 dark:border-zinc-600 rounded-lg p-4 cursor-pointer hover:bg-zinc-50 dark:hover:bg-zinc-800 transition"
                        @click="$refs.cvProfilePicture.click()">

                        <svg class="w-10 h-10 text-indigo-500 mb-2" fill="none" stroke="currentColor"
                            stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M12 5v14M5 12h14" />
                        </svg>
                        <span class="text-sm text-zinc-500 dark:text-zinc-400">
                            {{ __('frontend.click_to_upload_picture') }}
                        </span>

                    </div>
                </div>


            </div>

            <!-- Step 2: Work Experience -->
            <div x-show="$wire.cv_currentStep === 2" x-transition x-data="{
                activeTab: 'roads',
                experience_roads: @entangle('cv_experience_roads'),
                experience_airports: @entangle('cv_experience_airports'),
                addProject(tab) {
                    if (tab === 'roads') {
                        this.experience_roads = [...this.experience_roads, {
                            name: '',
                            start_date: '',
                            end_date: '',
                            description: ''
                        }];
                    } else {
                        this.experience_airports = [...this.experience_airports, {
                            name: '',
                            start_date: '',
                            end_date: '',
                            description: ''
                        }];
                    }
                },
                removeProject(tab, index) {
                    if (tab === 'roads') {
                        this.experience_roads.splice(index, 1);
                    } else {
                        this.experience_airports.splice(index, 1);
                    }
                }
            }">

                <h3 class="text-lg font-semibold text-zinc-700 dark:text-zinc-300 mb-2">
                    {{ __('frontend.work_experience') }}
                </h3>

                <!-- Tabs -->
                <div class="flex space-x-2 mb-4">
                    <button type="button" @click="activeTab = 'roads'"
                        :class="activeTab === 'roads' ? 'bg-indigo-600 text-white' :
                            'bg-zinc-200 dark:bg-zinc-700 text-zinc-700 dark:text-zinc-300'"
                        class="px-4 py-2 rounded-lg font-medium transition">
                        {{ __('frontend.roads') }}
                    </button>
                    <button type="button" @click="activeTab = 'airports'"
                        :class="activeTab === 'airports' ? 'bg-indigo-600 text-white' :
                            'bg-zinc-200 dark:bg-zinc-700 text-zinc-700 dark:text-zinc-300'"
                        class="px-4 py-2 rounded-lg font-medium transition">
                        {{ __('frontend.airports') }}
                    </button>
                </div>

                <!-- Projects List -->
                <template x-for="(project, index) in activeTab === 'roads' ? experience_roads : experience_airports"
                    :key="index">
                    <div
                        class="space-y-2 p-4 border border-zinc-300 dark:border-zinc-600 rounded-lg bg-white dark:bg-zinc-800 relative">

                        <button type="button" @click="removeProject(activeTab, index)"
                            class="absolute top-1 ltr:right-1 rtl:left-1 bg-red-600 hover:bg-red-700 text-white text-xs w-5 h-5 rounded-full shadow-md z-10 transition-transform transform hover:scale-110">
                            ×
                        </button>

                        <div>
                            <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                                {{ __('frontend.project_name') }}
                            </label>
                            <input type="text" x-model="project.name"
                                class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition" />
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                                {{ __('frontend.start_date') }}
                            </label>
                            <input type="date" x-model="project.start_date"
                                class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition" />
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                                {{ __('frontend.end_date') }}
                            </label>
                            <input type="date" x-model="project.end_date"
                                class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition" />
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                                {{ __('frontend.project_description') }}
                            </label>
                            <textarea x-model="project.description"
                                class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition"></textarea>
                        </div>

                    </div>
                </template>

                <!-- Add Project Button -->
                <div class="flex justify-center mt-4">
                    <button type="button" @click="addProject(activeTab)"
                        class="px-4 py-2 bg-indigo-600 text-white rounded-lg hover:bg-indigo-700 transition">
                        {{ __('frontend.add_project') }}
                    </button>
                </div>
            </div>

            <!-- Step 3: Skills & Submit -->
            <div x-show="$wire.cv_currentStep === 3" x-transition>

                <!-- Skills Input -->
                <div x-data="{
                    newSkill: '',
                    skills: @entangle('cv_skills'),
                    addSkill() {
                        if (this.newSkill.trim() !== '' && !this.skills.includes(this.newSkill.trim())) {
                            this.skills = [...this.skills, this.newSkill.trim()];
                            this.newSkill = '';
                        }
                    },
                    removeSkill(index) {
                        this.skills.splice(index, 1);
                    }
                }">
                    <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                        {{ __('frontend.skills') }}
                    </label>

                    <div class="flex gap-2 mb-2">
                        <input type="text" x-model="newSkill"
                            class="flex-1 px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition"
                            placeholder="{{ __('frontend.skills_placeholder') }}" @keydown.enter.prevent="addSkill" />
                        <button type="button" @click="addSkill"
                            class="px-4 py-2 bg-indigo-600 text-white rounded-lg hover:bg-indigo-700 transition">
                            +
                        </button>
                    </div>

                    <div class="flex flex-wrap gap-2">
                        <template x-for="(skill, index) in skills" :key="index">
                            <div
                                class="flex items-center bg-indigo-100 text-indigo-800 px-3 py-1 rounded-full text-sm font-medium">
                                <span x-text="skill"></span>
                                <button type="button" @click="removeSkill(index)"
                                    class="ml-2 text-indigo-500 hover:text-indigo-700">&times;</button>
                            </div>
                        </template>
                    </div>
                </div>
            </div>

            <!-- Navigation Buttons -->
            <div class="flex justify-between mt-6 space-x-2 rtl:space-x-reverse">
                <button type="button" wire:click="previousCvStep" x-show="$wire.cv_currentStep > 1"
                    class="px-5 py-2 bg-gray-200 dark:bg-zinc-700 text-gray-700 dark:text-white font-medium rounded-lg hover:bg-gray-300 dark:hover:bg-zinc-600 transition-all duration-300">
                    ← {{ __('frontend.previous') }}
                </button>

                <button type="button" wire:click="nextCvStep" x-show="$wire.cv_currentStep < 3"
                    class="px-5 py-2 bg-indigo-600 text-white font-medium rounded-lg hover:bg-indigo-700 transition-all duration-300">
                    {{ __('frontend.next') }} →
                </button>

                <button type="submit" x-show="$wire.cv_currentStep === 3"
                    class="px-5 py-2 bg-green-600 text-white font-medium rounded-lg hover:bg-green-700 transition-all duration-300">
                    🚀 {{ __('frontend.cv_submitbtn') }}
                </button>
            </div>

        </form>

    </div>
</div>
