<!-- livewire/backend/user/modals/privileges.blade.php -->

<div x-data="{ show: true }"
     x-cloak
     x-show="show"
     x-transition:enter="transition ease-out duration-300"
     x-transition:enter-start="opacity-0 scale-90"
     x-transition:enter-end="opacity-100 scale-100"
     x-transition:leave="transition ease-in duration-200"
     x-transition:leave-start="opacity-100 scale-100"
     x-transition:leave-end="opacity-0 scale-90"
     @keydown.escape.window="show = false; $wire.closeModal()"
     @click.away="show = false; $wire.closeModal()"
     class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 px-4 sm:px-6 lg:px-8">

    <div
        class="bg-white dark:bg-zinc-900 rounded-xl shadow-2xl border border-zinc-200 dark:border-zinc-700 w-full max-w-xl p-6 space-y-6 transition-all duration-300 overflow-y-auto max-h-[90vh]">

        <!-- Header -->
        <div class="flex justify-between items-center">
            <h3 class="text-xl font-bold text-zinc-800 dark:text-white">
                {{ __('backend.user_privileges') }}
            </h3>
            <button @click="show = false; $wire.closeModal()"
                class="text-zinc-500 hover:text-zinc-800 dark:hover:text-white text-2xl leading-none">
                &times;
            </button>
        </div>

        <!-- Content Placeholder -->
        <div class="text-center text-zinc-600 dark:text-zinc-400 py-10">
            {{ __('backend.content_placeholder') }}
        </div>

        <!-- Footer -->
        <div class="flex justify-end space-x-2 rtl:space-x-reverse">
            <button @click="show = false; $wire.closeModal()"
                class="px-4 py-2 rounded-lg text-sm bg-zinc-200 dark:bg-zinc-700 hover:bg-zinc-300 dark:hover:bg-zinc-600 text-zinc-800 dark:text-white">
                {{ __('backend.close') }}
            </button>
            <button @click="show = false; $wire.closeModal()"
                class="px-4 py-2 rounded-lg text-sm bg-green-600 text-white hover:bg-green-700">
                {{ __('backend.save') }}
            </button>
        </div>

    </div>
</div>
