<!-- 🔍 مربع البحث -->
<div class="mb-4 max-w-md">
    <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
        {{ __('backend.search_by_code_or_name') }}
    </label>
    <div class="relative">
        <input type="text" wire:model.live="projectSearch"
            class="w-full rounded-lg bg-white dark:bg-zinc-800 border border-zinc-300 dark:border-zinc-700 text-sm px-3 py-2"
            placeholder="{{ __('backend.search_placeholder') }}" />

        @if (!empty($suggestions))
            <ul
                class="absolute w-full bg-white dark:bg-zinc-900 border border-zinc-300 dark:border-zinc-700 mt-1 rounded-lg shadow z-50 text-sm">
                @foreach ($suggestions as $suggestion)
                    <li class="px-3 py-1 hover:bg-zinc-100 dark:hover:bg-zinc-800 cursor-pointer"
                        wire:click="selectSuggestion('{{ addslashes($suggestion) }}')">

                        {{ $suggestion }}
                    </li>
                @endforeach
            </ul>
        @endif
    </div>

</div>
