<div x-data="{ show: true }" x-show="show"
    x-transition:enter="transition ease-out duration-300"
    x-transition:enter-start="opacity-0 scale-90"
    x-transition:enter-end="opacity-100 scale-100"
    x-transition:leave="transition ease-in duration-200"
    x-transition:leave-start="opacity-100 scale-100"
    x-transition:leave-end="opacity-0 scale-90"
    class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 px-4 sm:px-6 lg:px-8"
    @click="if ($event.target === $event.currentTarget) { show = false; $wire.closeModal(); }">

    <div
        class="bg-white dark:bg-zinc-900 rounded-xl shadow-2xl border border-zinc-200 dark:border-zinc-700 w-full max-w-2xl p-6 space-y-6 transition-all duration-300"
        @click.stop>
        <!-- Header -->
        <div>
            <h3 class="text-2xl font-bold text-zinc-800 dark:text-white">
                {{ __('backend.add_project') }}
            </h3>
        </div>

        <!-- Form -->
        <form wire:submit.prevent="storeProject" class="space-y-4 text-sm">
            <!-- Code -->
            <div>
                <label class="block mb-1 text-zinc-700 dark:text-zinc-300">
                    {{ __('backend.project_code') }}
                </label>
                <input type="text" wire:model.defer="new.code" required
                    class="w-full rounded-lg bg-zinc-50 dark:bg-zinc-800 border border-zinc-400 dark:border-zinc-700 text-zinc-800 dark:text-zinc-100 p-2 focus:ring-indigo-500 focus:border-indigo-500 transition" />
            </div>

            <!-- Name -->
            <div>
                <label class="block mb-1 text-zinc-700 dark:text-zinc-300">
                    {{ __('backend.project_name') }}
                </label>
                <input type="text" wire:model.defer="new.name" required
                    class="w-full rounded-lg bg-zinc-50 dark:bg-zinc-800 border border-zinc-400 dark:border-zinc-700 text-zinc-800 dark:text-zinc-100 p-2 focus:ring-indigo-500 focus:border-indigo-500 transition" />
            </div>

            <!-- Manager -->
            <div>
                <label class="block mb-1 text-zinc-700 dark:text-zinc-300">
                    {{ __('backend.manager') }}
                </label>
                <select wire:model.defer="new.manager_id"
                    class="w-full rounded-lg bg-zinc-50 dark:bg-zinc-800 border border-zinc-400 dark:border-zinc-700 text-zinc-800 dark:text-zinc-100 p-2 focus:ring-indigo-500 focus:border-indigo-500 transition">
                    <option value="">{{ __('backend.select') }}</option>
                    @foreach ($employees as $emp)
                        @if (!empty($emp->full_name_translated))
                            <option value="{{ $emp->id }}">{{ $emp->full_name_translated }}</option>
                        @endif
                    @endforeach
                </select>
            </div>

            <!-- Description -->
            <div>
                <label class="block mb-1 text-zinc-700 dark:text-zinc-300">
                    {{ __('backend.project_description') }}
                </label>
                <textarea wire:model.defer="new.description"
                    class="w-full rounded-lg bg-zinc-50 dark:bg-zinc-800 border border-zinc-400 dark:border-zinc-700 text-zinc-800 dark:text-zinc-100 p-2 focus:ring-indigo-500 focus:border-indigo-500 transition"></textarea>
            </div>

            <!-- Buttons -->
            <div class="pt-4 flex justify-end gap-3">
                <button type="button" @click="show = false; $wire.closeModal()"
                    class="px-4 py-2 bg-gray-200 dark:bg-zinc-700 text-gray-800 dark:text-white rounded-lg hover:bg-gray-300 dark:hover:bg-zinc-600 transition">
                    {{ __('backend.cancel') }}
                </button>
                <button type="submit"
                    class="px-4 py-2 bg-indigo-600 hover:bg-indigo-700 text-white rounded-lg transition">
                    {{ __('backend.save_project') }}
                </button>
            </div>
        </form>
    </div>
</div>
