<?php

use Livewire\Volt\Component;
use Livewire\WithFileUploads;
use App\Models\User\UserEmployeeReview;
use Illuminate\Support\Collection;
use Livewire\WithPagination;
use Maatwebsite\Excel\Facades\Excel;
use Livewire\Attributes\Layout;
use Illuminate\Support\Facades\Response;
use Illuminate\View\View;


new #[Layout('components.backend.layouts.struct')] class extends Component {

    use WithFileUploads;

    public $file;

    public function uploadAndCompare()
    {
        $this->validate([
            'file' => 'required|file|mimes:xlsx,csv',
        ]);

        $path = $this->file->store('temp'); // نخزن الملف مؤقتًا

        // قراءة البيانات
        $collection = Excel::toCollection(null, storage_path('app/' . $path))->first();

        foreach ($collection as $row) {
            // مثال مبسط للمقارنة: على حسب الكود أو الرقم القومي
            $existingEmployee = \App\Models\User\UserEmployee::where('national_id', $row['national_id'])->first();

            if ($existingEmployee) {
                $status = 'matched';
            } else {
                $status = 'not_found';
            }

            UserEmployeeReview::create([
                'employee_code' => $row['employee_code'] ?? null,
                'national_id' => $row['national_id'],
                'full_name' => [
                    'ar' => $row['full_name_ar'] ?? null,
                    'en' => $row['full_name_en'] ?? null,
                ],
                'status' => $status,
                // باقي الحقول لو تحب تملاها كمان
            ]);
        }

        session()->flash('success', 'File uploaded and compared successfully!');
    }

    public function render(): mixed
    {
        return view('livewire.backend.employee.review');
    }
};

?>
<div class="p-6">
    <form wire:submit.prevent="uploadAndCompare" class="flex flex-col gap-4">

        <input type="file" wire:model="file"
            class="input input-bordered dark:bg-zinc-800 dark:border-zinc-600 w-full" />

        @error('file') <span class="text-red-600">{{ $message }}</span> @enderror

        <button type="submit"
            class="px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-md shadow">
            📤 {{ __('Upload and Compare') }}
        </button>

    </form>

    @if (session()->has('success'))
        <div class="mt-4 text-green-600">
            {{ session('success') }}
        </div>
    @endif
</div>
