<div x-show="$wire.currentStep === 3">

    <h2 class="text-2xl font-bold text-zinc-800 dark:text-white mb-6 text-center">
        📝 {{ __('frontend.cv_section_title') }} <!-- ترجم في lang/ar -->
    </h2>

    <!-- Profile Picture Upload -->
    <div class="mb-6" x-data>
        <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-2">
            {{ __('frontend.upload_profile_picture') }}
        </label>

        <div class="flex flex-col items-center justify-center border-2 border-dashed border-zinc-300 dark:border-zinc-600 rounded-lg p-4 cursor-pointer hover:bg-zinc-50 dark:hover:bg-zinc-800 transition"
            @click="$refs.profilePicture.click()">

            <svg class="w-10 h-10 text-indigo-500 mb-2" fill="none" stroke="currentColor" stroke-width="2"
                viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round">
                <path d="M12 5v14M5 12h14" />
            </svg>
            <span class="text-sm text-zinc-500 dark:text-zinc-400">
                {{ __('frontend.click_to_upload_picture') }}
            </span>

            <input type="file" x-ref="profilePicture" wire:model.live="new.profile_picture" class="hidden"
                accept="image/jpeg,image/png,image/jpg" />
        </div>

        @if (!empty($new['profile_picture']))
            <div class="mt-3">
                <img src="{{ $new['profile_picture']->temporaryUrl() }}"
                    class="w-24 h-24 object-cover rounded-full border border-zinc-300 dark:border-zinc-600 mx-auto" />
            </div>
        @endif
    </div>


    <!-- Work Experience Section -->
    <div x-data="{
        activeTab: 'roads',
        experience_roads: @entangle('new.experience_roads'),
        experience_airports: @entangle('new.experience_airports'),
        addProject(tab) {
            if (tab === 'roads') {
                this.experience_roads = [...this.experience_roads, {
                    name: '',
                    start_date: '',
                    end_date: '',
                    description: ''
                }];
            } else {
                this.experience_airports = [...this.experience_airports, {
                    name: '',
                    start_date: '',
                    end_date: '',
                    description: ''
                }];
            }
        },

        removeProject(tab, index) {
            if (tab === 'roads') {
                this.experience_roads.splice(index, 1);
            } else {
                this.experience_airports.splice(index, 1);
            }
        }

    }" class="space-y-4">

        <h3 class="text-lg font-semibold text-zinc-700 dark:text-zinc-300 mb-2">
            {{ __('frontend.work_experience') }}
        </h3>

        <!-- Tabs -->
        <div class="flex space-x-2 mb-4">
            <button type="button" @click="activeTab = 'roads'"
                :class="activeTab === 'roads' ? 'bg-indigo-600 text-white' :
                    'bg-zinc-200 dark:bg-zinc-700 text-zinc-700 dark:text-zinc-300'"
                class="px-4 py-2 rounded-lg font-medium transition">
                {{ __('frontend.roads') }}
            </button>
            <button type="button" @click="activeTab = 'airports'"
                :class="activeTab === 'airports' ? 'bg-indigo-600 text-white' :
                    'bg-zinc-200 dark:bg-zinc-700 text-zinc-700 dark:text-zinc-300'"
                class="px-4 py-2 rounded-lg font-medium transition">
                {{ __('frontend.airports') }}
            </button>
        </div>

        <!-- Projects List -->
        <template x-for="(project, index) in activeTab === 'roads' ? experience_roads : experience_airports"
            :key="index">
            <div
                class="space-y-2 p-4 border border-zinc-300 dark:border-zinc-600 rounded-lg bg-white dark:bg-zinc-800 relative">

                <!-- Remove button -->
                <button type="button" @click="removeProject(activeTab, index)"
                    class="absolute top-1 ltr:right-1 rtl:left-1 bg-red-600 hover:bg-red-700 text-white text-xs w-5 h-5 rounded-full shadow-md z-10 transition-transform transform hover:scale-110">
                    ×
                </button>


                <!-- Project Name -->
                <div>
                    <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                        {{ __('frontend.project_name') }}
                    </label>
                    <input type="text" x-model="project.name"
                        class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition"
                        placeholder="{{ __('frontend.project_name_placeholder') }}" />
                </div>

                <!-- Start Date -->
                <div>
                    <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                        {{ __('frontend.start_date') }}
                    </label>
                    <input type="date" x-model="project.start_date"
                        class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition" />
                </div>

                <!-- End Date -->
                <div>
                    <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                        {{ __('frontend.end_date') }}
                    </label>
                    <input type="date" x-model="project.end_date"
                        class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition" />
                </div>

                <!-- Project Description -->
                <div>
                    <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                        {{ __('frontend.project_description') }}
                    </label>
                    <textarea x-model="project.description"
                        class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition"
                        placeholder="{{ __('frontend.project_description_placeholder') }}"></textarea>
                </div>

            </div>
        </template>

        <!-- Add Project Button -->
        <div class="flex justify-center mt-4">
            <button type="button" @click="addProject(activeTab)"
                class="px-4 py-2 bg-indigo-600 text-white rounded-lg hover:bg-indigo-700 transition">
                {{ __('frontend.add_project') }}
            </button>
        </div>
    </div>

    <!-- Skills Input -->
    <div x-data="{
        newSkill: '',
        skills: @entangle('new.skills'),
        addSkill() {
            if (this.newSkill.trim() !== '' && !this.skills.includes(this.newSkill.trim())) {
                this.skills.push(this.newSkill.trim());
                this.newSkill = '';
            }
        },
        removeSkill(index) {
            this.skills.splice(index, 1);
        }
    }">
        <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
            {{ __('frontend.skills') }}
        </label>

        <div class="flex gap-2 mb-2">
            <input type="text" x-model="newSkill"
                class="flex-1 px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition"
                placeholder="{{ __('frontend.skills_placeholder') }}" @keydown.enter.prevent="addSkill" />
            <button type="button" @click="addSkill"
                class="px-4 py-2 bg-indigo-600 text-white rounded-lg hover:bg-indigo-700 transition">
                +
            </button>
        </div>

        <!-- Skills List -->
        <div class="flex flex-wrap gap-2">
            <template x-for="(skill, index) in skills" :key="index">
                <div class="flex items-center bg-indigo-100 text-indigo-800 px-3 py-1 rounded-full text-sm font-medium">
                    <span x-text="skill"></span>
                    <button type="button" @click="removeSkill(index)"
                        class="ml-2 text-indigo-500 hover:text-indigo-700">&times;</button>
                </div>
            </template>
        </div>
    </div>

    <!-- ID Card Images Upload -->
    <!-- Drag & Drop + Input file -->
    <div x-data="{
        dragging: false,
        handleDrop(e) {
            this.dragging = false;

            let files = Array.from(e.dataTransfer.files);

            // إرسال الملفات يدويًا إلى Livewire
            $wire.uploadMultiple('new.id_card_images', files,
                () => {}, // success
                () => {} // error
            );
        }
    }" x-on:dragover.prevent="dragging = true" x-on:dragleave.prevent="dragging = false"
        x-on:drop.prevent="handleDrop($event)"
        class="relative border-2 border-dashed rounded-lg p-6 flex flex-col items-center justify-center transition duration-300"
        :class="{
            'border-indigo-500 bg-indigo-50': dragging,
            'border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800':
                !dragging
        }">

        <!-- Label -->
        <div class="mb-2">
            <label class="block text-sm font-semibold text-zinc-700 dark:text-zinc-300">
                {{ __('frontend.attach_documents') }}
            </label>
            <p class="text-xs text-zinc-500 dark:text-zinc-400 mt-1">
                {{ __('frontend.required_documents_hint') }}
            </p>
            <ul class="list-disc list-inside text-xs text-zinc-500 dark:text-zinc-400 mt-1 space-y-1">
                <li>{{ __('frontend.document_id_card') }}</li>
                <li>{{ __('frontend.document_national_id') }}</li>
                <li>{{ __('frontend.document_work_experience_certificates') }}</li>
            </ul>
        </div>

        <p class="text-sm text-zinc-500 dark:text-zinc-400 mb-2 text-center">
            {{ __('frontend.drag_here_or') }}
        </p>

        <label for="id_card_images"
            class="cursor-pointer bg-indigo-600 text-white text-sm px-4 py-2 rounded-md hover:bg-indigo-700 transition">
            {{ __('frontend.choose_files') }}
            <input type="file" id="id_card_images" multiple wire:model.live="new.id_card_images" class="hidden"
                accept="image/*,application/pdf" />

        </label>

    </div>

    @if (!empty($new['id_card_images']))
        @foreach ($new['id_card_images'] as $index => $file)
            <div
                class="relative group w-[120px] h-[120px] flex flex-col items-center justify-center border border-zinc-300 dark:border-zinc-600 rounded-lg bg-white dark:bg-zinc-800 shadow-sm overflow-hidden">

                <!-- زر الحذف -->
                <button wire:click.prevent="removeImage({{ $index }})"
                    class="absolute top-1 right-1 bg-red-600 hover:bg-red-700 text-white text-xs w-5 h-5 rounded-full shadow-md z-10">
                    ×
                </button>

                @if (Str::endsWith($file->getClientOriginalName(), '.pdf'))
                    <div class="flex flex-col items-center justify-center px-2 text-center">
                        <div class="text-3xl">📄</div>
                        <span class="text-[10px] text-zinc-600 dark:text-zinc-300 truncate w-[90%]">
                            {{ Str::limit($file->getClientOriginalName(), 14) }}
                        </span>
                    </div>
                @else
                    <div
                        class="w-[100px] h-[100px] overflow-hidden rounded-md border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800">
                        <img src="{{ $file->temporaryUrl() }}" class="w-full h-full object-cover" />
                    </div>
                    <span class="text-[10px] text-zinc-600 dark:text-zinc-300 truncate w-[90%] mt-1">
                        {{ Str::limit($file->getClientOriginalName(), 14) }}
                    </span>
                @endif
            </div>
        @endforeach
    @endif


    <!-- Qualification -->
    <div>
        <label for="qualification" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
            {{ __('backend.qualification') }}
        </label>
        <input type="text" id="qualification" required
            placeholder="{{ __('backend.qualification_placeholder') }}"
            class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition"
            wire:model.defer="new.qualification" />
    </div>

    <!-- Graduation Year -->
    <div>
        <label for="graduation_year" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
            {{ __('backend.graduation_year') }}
        </label>
        <input type="number" id="graduation_year" required
            placeholder="{{ __('backend.graduation_year_placeholder') }}"
            class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition"
            wire:model.defer="new.graduation_year" />
    </div>

    <!-- Graduation Project -->
    <div>
        <label for="graduation_project" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
            {{ __('backend.graduation_project') }}
        </label>
        <input type="text" id="graduation_project" required
            placeholder="{{ __('backend.graduation_project_placeholder') }}"
            class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition"
            wire:model.defer="new.graduation_project" />
    </div>

    <!-- Military Status -->
    <div>
        <label for="military_status" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
            {{ __('backend.military_status') }}
        </label>
        <select id="military_status" required
            class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition"
            wire:model.defer="new.military_status">
            <option value="exempted">{{ __('backend.exempted') }}</option>
            <option value="completed">{{ __('backend.completed') }}</option>
            <option value="postponed">{{ __('backend.postponed') }}</option>
            <option value="not_required">{{ __('backend.not_required') }}</option>
        </select>
    </div>



</div>
