
<div x-show="$wire.currentStep === 2">
    <!-- National ID -->
    <div>
        <label for="national_id" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
            {{ __('frontend.national_id') }}
        </label>
        <div
            class="flex rounded-lg overflow-hidden border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 focus-within:ring-2 focus-within:ring-indigo-500 transition-all duration-300">
            <div
                class="flex items-center px-3 bg-zinc-100 dark:bg-zinc-700 border-r border-zinc-300 dark:border-zinc-600 text-indigo-500 dark:text-indigo-400">
                <!-- id icon -->
                <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2"
                    viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M16 21v-2a4 4 0 00-8 0v2" />
                    <circle cx="12" cy="7" r="4" />
                    <rect x="2" y="3" width="20" height="18" rx="2" ry="2" />
                </svg>
            </div>
            <input type="text" id="national_id" maxlength="14" required placeholder="xxxxxxxxxxxxxx"
                class="flex-1 px-4 py-2 text-zinc-900 dark:text-white bg-transparent outline-none"
                wire:model.defer="editcv.national_id" />
        </div>
    </div>
    <!-- Project -->
    <div>
        <label for="project_code" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
            {{ __('frontend.project') }}
        </label>
        <div
            class="flex rounded-lg overflow-hidden border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 focus-within:ring-2 focus-within:ring-indigo-500 transition-all duration-300">
            <div
                class="flex items-center px-3 bg-zinc-100 dark:bg-zinc-700 border-r border-zinc-300 dark:border-zinc-600 text-indigo-500 dark:text-indigo-400">
                <!-- project icon -->
                <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2"
                    viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M21 16V8a2 2 0 0 0-2-2H5a2 2 0 0 0-2 2v8" />
                    <rect x="7" y="12" width="3" height="6" />
                    <rect x="14" y="12" width="3" height="6" />
                    <path d="M12 12V4" />
                </svg>
            </div>
            <select id="project_code" wire:model.defer="editcv.project_code" required
                class="flex-1 px-4 py-2 bg-transparent text-zinc-900 dark:text-white outline-none appearance-none">
                <option value="">{{ __('frontend.chooseproject') }}</option>
                @foreach (App\Models\User\UserProject::all() as $project)
                    <option value="{{ $project->code }}">{{ $project->name }}</option>
                @endforeach
            </select>
        </div>
    </div>

    <!-- Hire Date -->
    <div>
        <label for="hire_date" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
            {{ __('frontend.hire_date') }}
        </label>
        <input type="date" id="hire_date" required
            class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition"
            wire:model.defer="editcv.hire_date" />
    </div>

    <!-- Contract Date -->
    <div>
        <label for="contract_date" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
            {{ __('frontend.contract_date') }}
        </label>
        <input type="date" id="contract_date" required
            class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition"
            wire:model.defer="editcv.contract_date" />
    </div>

    <!-- Job Title -->
    <div>
        <label for="job_title_id" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
            {{ __('frontend.job_title') }}
        </label>
        <div
            class="flex rounded-lg overflow-hidden border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 focus-within:ring-2 focus-within:ring-indigo-500 transition-all duration-300">
            <div
                class="flex items-center px-3 bg-zinc-100 dark:bg-zinc-700 border-r border-zinc-300 dark:border-zinc-600 text-indigo-500 dark:text-indigo-400">
                <!-- briefcase icon -->
                <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2"
                    viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round">
                    <rect x="2" y="7" width="20" height="14" rx="2" ry="2">
                    </rect>
                    <path d="M16 3h-8a2 2 0 0 0-2 2v2h12V5a2 2 0 0 0-2-2z"></path>
                </svg>
            </div>
            <select id="job_title_id" wire:model.defer="editcv.job_title_id" required
                class="flex-1 px-4 py-2 bg-transparent text-zinc-900 dark:text-white outline-none appearance-none">
                <option value="">{{ __('frontend.choosejobtitle') }}</option>
                @foreach (App\Models\User\UserJobTitle::get() as $jobTitle)
                    <option value="{{ $jobTitle->id }}">
                        {{ app()->getLocale() == 'ar' ? $jobTitle->title_ar : $jobTitle->title_en }}
                    </option>
                @endforeach
            </select>
        </div>
    </div>


</div>
