{{-- resources/views/livewire/backend/user/modals/emp-moves.blade.php --}}
<div x-data="{
    show: true,
    movements: @entangle('movements'),
    editType: @entangle('editType'),
    editOpenEnded: @entangle('editOpenEnded'),
    editApplyNow: @entangle('editApplyNow'),
    currentStep: 1,
    deleteId: @entangle('deleteMovementId'),
}" x-init="$wire.loadMovements({{ $movementEmployeeId }})" x-show="show" x-cloak
    @movement-updated.window="currentStep = 1; $wire.loadMovements({{ $movementEmployeeId }})"
    @keydown.escape.window="show = false; $wire.closeModal()"
    class="fixed inset-0 z-50 flex items-center justify-center p-4 bg-black/50">
    <div
        class="bg-white dark:bg-zinc-900 rounded-2xl shadow-xl w-full max-w-2xl p-6 space-y-6 overflow-y-auto max-h-[90vh]
           transform transition-all duration-300 ease-out
           rtl:font-sans ltr:font-sans">


        <!-- Header ثابت داخل الـ modal -->
<div class="flex justify-between items-center mb-4">
    <h3 class="text-xl font-semibold text-zinc-800 dark:text-zinc-100"
        x-text="{
            1: '{{ __('backend.employee_movements') }} : {{ $employeeName }}',
            2: '{{ __('backend.employee_movements_edit') }} : {{ $employeeName }}',
            3: '{{ __('backend.employee_movements_delete') }} : {{ $employeeName }}'
        }[currentStep]">
        <!-- fallback لو JavaScript مُعطّل -->
        {{ __('backend.employee_movements') }} : {{ $employeeName }}
    </h3>

    <button @click="show = false; $wire.closeModal()"
        class="text-zinc-500 hover:text-zinc-800 dark:hover:text-white text-2xl leading-none transition-colors">&times;</button>
</div>

        {{-- Step 1: قائمة الحركات --}}
        <template x-if="currentStep === 1">
            <div class="space-y-4">
                <table class="w-full table-auto text-sm text-zinc-800 dark:text-zinc-200">
                    <thead class="bg-zinc-100 dark:bg-zinc-800">
                        <tr>
                            <th class="px-3 py-2">{{ __('backend.type') }}</th>
                            <th class="px-3 py-2">{{ __('backend.start_date') }}</th>
                            <th class="px-3 py-2">{{ __('backend.end_date') }}</th>
                            <th class="px-3 py-2">{{ __('backend.status') }}</th>
                            <th class="px-3 py-2 text-right">{{ __('backend.actions') }}</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-zinc-200 dark:divide-zinc-700">
                        <template x-for="m in movements" :key="m.id">
                            <tr class="hover:bg-zinc-50 dark:hover:bg-zinc-800">
                                <td class="px-3 py-2">
                                    <span
                                    :class="{
                                        'inline-block font-medium': true,
                                        'text-green-600': m.type === 'mission',
                                        'text-blue-600': m.type === 'transfer',
                                        'text-red-600': m.type === 'termination',
                                      }"
                                        x-text="{
                                mission:     '{{ __('backend.mission') }}',
                                transfer:    '{{ __('backend.title_transfer') }}',
                                termination: '{{ __('backend.termination') }}',
                              }[m.type] || m.type"></span>
                                </td>

                                <td class="px-3 py-2" x-text="m.start_date"></td>
                                <td class="px-3 py-2" x-text="m.end_date || '-'"></td>
                                <td class="px-3 py-2">
                                    <span
                                        :class="{
                                            'inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium transition': true,
                                            'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-100': m
                                                .status === 'activated',
                                            'bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-100': m
                                                .status === 'pending',
                                            'bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-200': m
                                                .status === 'applied',
                                            'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-100': m
                                                .status === 'cancelled',
                                        }"
                                        x-text="{
                          activated: '{{ __('backend.status_activated') }}',
                          pending:   '{{ __('backend.status_pending') }}',
                          applied:   '{{ __('backend.status_applied') }}',
                          cancelled: '{{ __('backend.status_cancelled') }}',
                        }[m.status]"></span>
                                </td>
                                <td class="px-3 py-2 text-right space-x-1">
                                    <button @click="currentStep = 2; $wire.editMovement(m.id)"
                                        class="px-2 py-1 bg-yellow-500 text-white text-xs rounded">{{ __('backend.edit') }}</button>
                                    <button @click="deleteId = m.id; currentStep = 3"
                                        class="px-2 py-1 bg-red-600 text-white text-xs rounded">{{ __('backend.delete') }}</button>
                                </td>
                            </tr>
                        </template>
                    </tbody>
                </table>
            </div>
        </template>

        {{-- Step 2: نموذج تعديل الحركة --}}
        <template x-if="currentStep === 2">
            <div class="space-y-4">
                <form wire:submit.prevent="updateMovement" class="space-y-6">

                    <!-- 1. نوع الحركة -->
                    <div x-transition:enter="transition ease-out duration-300"
                        x-transition:enter-start="opacity-0 -translate-y-2"
                        x-transition:enter-end="opacity-100 translate-y-0"
                        x-transition:leave="transition ease-in duration-200"
                        x-transition:leave-start="opacity-100 translate-y-0"
                        x-transition:leave-end="opacity-0 -translate-y-2">
                        <label for="editType" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300">
                            {{ __('backend.movement_type') }}
                        </label>
                        <select id="editType" wire:model="editType"
                            class="mt-1 block w-full rounded-lg border border-gray-300 dark:border-zinc-700 bg-white dark:bg-zinc-800
                                   px-3 py-2 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-green-500 transition-colors">
                            <option value="">{{ __('backend.select_type') }}</option>
                            <option value="mission">{{ __('backend.mission') }}</option>
                            <option value="transfer">{{ __('backend.transfer') }}</option>
                            <option value="termination">{{ __('backend.termination') }}</option>
                        </select>
                        @error('editType')
                            <span class="text-red-600 text-sm">{{ $message }}</span>
                        @enderror
                    </div>

                    <!-- 1.1 تنفيذ الآن -->
                    <template x-if="editType !== ''">
                        <div x-cloak x-transition:enter="transition ease-out duration-300"
                            x-transition:enter-start="opacity-0 -translate-y-2"
                            x-transition:enter-end="opacity-100 translate-y-0"
                            x-transition:leave="transition ease-in duration-200"
                            x-transition:leave-start="opacity-100 translate-y-0"
                            x-transition:leave-end="opacity-0 -translate-y-2">
                            <label
                                class="flex items-center space-x-2 rtl:space-x-reverse text-sm text-zinc-700 dark:text-zinc-300">
                                <input type="checkbox" wire:model.defer="editApplyNow"
                                    class="form-checkbox h-5 w-5 text-green-600 focus:ring-green-500 transition-colors">
                                {{ __('backend.apply_now') }}
                            </label>
                        </div>
                    </template>

                    <!-- 2. تاريخ البداية -->
                    <div x-show="editType !== '' && !editApplyNow" x-cloak
                        x-transition:enter="transition ease-out duration-300"
                        x-transition:enter-start="opacity-0 -translate-y-2"
                        x-transition:enter-end="opacity-100 translate-y-0"
                        x-transition:leave="transition ease-in duration-200"
                        x-transition:leave-start="opacity-100 translate-y-0"
                        x-transition:leave-end="opacity-0 -translate-y-2">
                        <label for="editStartDate" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300">
                            {{ __('backend.start_date') }}
                        </label>
                        <input type="date" id="editStartDate" wire:model.defer="editStartDate"
                            class="mt-1 block w-full rounded-lg border border-gray-300 dark:border-zinc-700 bg-white dark:bg-zinc-800
                                   px-3 py-2 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-green-500 transition-colors">
                        @error('editStartDate')
                            <span class="text-red-600 text-sm">{{ $message }}</span>
                        @enderror
                    </div>

                    <!-- 3. تاريخ النهاية لمأمورية -->
                    <template x-if="editType === 'mission'">
                        <div x-cloak x-transition:enter="transition ease-out duration-300"
                            x-transition:enter-start="opacity-0 -translate-y-2"
                            x-transition:enter-end="opacity-100 translate-y-0"
                            x-transition:leave="transition ease-in duration-200"
                            x-transition:leave-start="opacity-100 translate-y-0"
                            x-transition:leave-end="opacity-0 -translate-y-2" class="space-y-2">
                            <label
                                class="flex items-center space-x-2 rtl:space-x-reverse text-sm text-zinc-700 dark:text-zinc-300">
                                <input type="checkbox" wire:model.defer="editOpenEnded"
                                    class="form-checkbox h-5 w-5 text-green-600 focus:ring-green-500 transition-colors">
                                {{ __('backend.open_ended') }}
                            </label>

                            <div x-show="!editOpenEnded" class="pt-1" x-cloak>
                                <label for="editEndDate"
                                    class="block text-sm font-medium text-zinc-700 dark:text-zinc-300">
                                    {{ __('backend.end_date') }}
                                </label>
                                <input type="date" id="editEndDate" wire:model.defer="editEndDate"
                                    class="mt-1 block w-full rounded-lg border border-gray-300 dark:border-zinc-700 bg-white dark:bg-zinc-800
                                           px-3 py-2 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-green-500 transition-colors">
                                @error('editEndDate')
                                    <span class="text-red-600 text-sm">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                    </template>

                    <!-- 4. اختيار المشروع الوجهة -->
                    <div x-show="editType === 'mission' || editType === 'transfer'" x-cloak
                        x-transition:enter="transition ease-out duration-300"
                        x-transition:enter-start="opacity-0 -translate-y-2"
                        x-transition:enter-end="opacity-100 translate-y-0"
                        x-transition:leave="transition ease-in duration-200"
                        x-transition:leave-start="opacity-100 translate-y-0"
                        x-transition:leave-end="opacity-0 -translate-y-2">
                        <label for="editToProject" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300">
                            {{ __('backend.to_project') }}
                        </label>
                        <select id="editToProject" wire:model.defer="editToProject"
                            class="mt-1 block w-full rounded-lg border border-gray-300 dark:border-zinc-700 bg-white dark:bg-zinc-800
                                   px-3 py-2 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-green-500 transition-colors">
                            <option value="">{{ __('backend.select_project') }}</option>
                            @foreach ($projects as $proj)
                                <option value="{{ $proj['id'] }}">{{ $proj['name'] }}</option>
                            @endforeach
                        </select>
                        @error('editToProject')
                            <span class="text-red-600 text-sm">{{ $message }}</span>
                        @enderror
                    </div>

                    <!-- 5. الملاحظات -->
                    <div x-transition:enter="transition ease-out duration-300"
                        x-transition:enter-start="opacity-0 -translate-y-2"
                        x-transition:enter-end="opacity-100 translate-y-0"
                        x-transition:leave="transition ease-in duration-200"
                        x-transition:leave-start="opacity-100 translate-y-0"
                        x-transition:leave-end="opacity-0 -translate-y-2">
                        <label for="editNotes" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300">
                            {{ __('backend.notes') }}
                        </label>
                        <textarea id="editNotes" rows="4" wire:model.defer="editNotes"
                            class="mt-1 block w-full rounded-lg border border-gray-300 dark;border-zinc-700 bg-white dark:bg-zinc-800
                                   px-3 py-2 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-green-500 transition-colors"></textarea>
                        @error('editNotes')
                            <span class="text-red-600 text-sm">{{ $message }}</span>
                        @enderror
                    </div>

                    <!-- Footer Buttons -->

                    {{-- Buttons --}}
                    <div class="flex justify-end space-x-2 rtl:space-x-reverse">
                        <button type="button" @click="currentStep = 1"
                            class="px-4 py-2 bg-gray-300 dark:bg-zinc-700 rounded text-sm font-medium hover:bg-gray-400 dark:hover:bg-zinc-600 transition">{{ __('backend.back') }}</button>
                        <button type="submit"
                            class="px-4 py-2 bg-green-600 hover:bg-green-700 text-white rounded text-sm font-medium transition">{{ __('backend.save_changes') }}</button>
                    </div>


                </form>


            </div>
        </template>


        {{-- Step 3: إلغاء الحركة مع كتابة السبب --}}
        <template x-if="currentStep === 3">
            <form wire:submit.prevent="cancelMovement" class="space-y-6">

                {{-- تفاصيل الحركة --}}
                <div class="p-4 bg-zinc-50 dark:bg-zinc-800 rounded-lg text-sm space-y-1">
                    <template x-if="movements.find(x => x.id === deleteId)">
                        <div x-data="{ mov: movements.find(x => x.id === deleteId) }">
                            <div>
                                <strong>{{ __('backend.type') }}:</strong>
                                <span
                                    :class="{
                                        'inline-block font-medium': true,
                                        'text-green-600': mov.type === 'mission',
                                        'text-blue-600': mov.type === 'transfer',
                                        'text-red-600': mov.type === 'termination',
                                    }"
                                    x-text="{
                        mission:     '{{ __('backend.mission') }}',
                        transfer:    '{{ __('backend.transfer') }}',
                        termination: '{{ __('backend.termination') }}',
                      }[mov.type] || mov.type"></span>
                            </div>
                            <div><strong>{{ __('backend.start_date') }}:</strong> <span x-text="mov.start_date" />
                            </div>
                            <div><strong>{{ __('backend.end_date') }}:</strong> <span x-text="mov.end_date || '-'" />
                            </div>
                            <div>
                                <strong>{{ __('backend.status') }}:</strong>
                                <span
                                    :class="{
                                        'inline-block px-2 py-0.5 rounded text-sm': true,
                                        'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-100': mov
                                            .status === 'activated',
                                        'bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-100': mov
                                            .status === 'pending',
                                        'bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-200': mov
                                            .status === 'applied',
                                        'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-100': mov
                                            .status === 'cancelled',
                                    }"
                                    x-text="{
                    activated:   '{{ __('backend.status_activated') }}',
                    pending:     '{{ __('backend.status_pending') }}',
                    applied:     '{{ __('backend.status_applied') }}',
                    cancelled:   '{{ __('backend.status_cancelled') }}',
                  }[mov.status] || mov.status"></span>
                            </div>
                        </div>
                    </template>
                </div>

                {{-- سبب الإلغاء --}}
                <div class="space-y-2">
                    <label class="block text-red-700 font-medium">{{ __('backend.reason_for_cancellation') }}</label>
                    <textarea wire:model.defer="cancelReason" rows="4" class="w-full border rounded p-2"
                        placeholder="{{ __('backend.cancel_reason_placeholder') }}"></textarea>
                    @error('cancelReason')
                        <span class="text-red-600">{{ $message }}</span>
                    @enderror
                </div>

                {{-- أزرار العودة والتأكيد --}}
                <div class="flex justify-end space-x-2">
                    <button type="button" @click="currentStep = 1; deleteId = null; $wire.set('cancelReason', null)"
                        class="px-4 py-2 bg-gray-300 rounded">{{ __('backend.back') }}</button>
                    <button type="submit" class="px-4 py-2 bg-red-600 text-white rounded">
                        {{ __('backend.confirm') }}
                    </button>
                </div>
            </form>
        </template>




    </div>
</div>
