<div x-data="{ show: true }" x-show="show" x-transition:enter="transition ease-out duration-300"
    x-transition:enter-start="opacity-0 transform scale-95" x-transition:enter-end="opacity-100 transform scale-100"
    x-transition:leave="transition ease-in duration-200" x-transition:leave-start="opacity-100 transform scale-100"
    x-transition:leave-end="opacity-0 transform scale-90"
    class="fixed inset-0 bg-black/50 flex items-center justify-center z-50"
    @click.away="show = false; $wire.closeModal()">

    <div
        class="bg-white dark:bg-zinc-900 rounded-lg shadow-xl border border-zinc-200 dark:border-zinc-700 w-full max-w-4xl p-6 overflow-y-auto max-h-[90vh] text-sm text-zinc-700 dark:text-zinc-300">
        <!-- Header -->
        <div class="mb-4">
            <h3 class="text-xl font-bold text-zinc-800 dark:text-white">
                {{ __('backend.user_details') }}
            </h3>
        </div>

        @php
            $cv = is_array($selectedEmp?->cv) ? $selectedEmp->cv : json_decode($selectedEmp->cv, true);

            $cv_profile_picture =
                isset($cv['profile_picture']) && $cv['profile_picture']
                    ? str_replace(['\\', '//'], '/', $cv['profile_picture'])
                    : null;

            $id_card_images = is_array($selectedEmp?->id_card_image)
                ? array_map(fn($img) => str_replace(['\\', '//'], '/', $img), $selectedEmp->id_card_image)
                : [];

            $cv_experience_roads = $cv['work_experience']['roads'] ?? [];
            $cv_experience_airports = $cv['work_experience']['airports'] ?? [];
            $cv_skills = $cv['skills'] ?? [];

        @endphp

        <!-- User details -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">

            <div>
                <strong>{{ __('frontend.fullname') }}:</strong>
                <div>{{ $selectedEmp?->full_name_translated ?? '-' }}</div>
            </div>
            <div>
                <strong>{{ __('frontend.job_title') }}:</strong>
                <div>{{ $selectedEmp?->jobTitle?->title_ar ?? '-' }}</div>
            </div>
            <div>
                <strong>{{ __('frontend.emailadress') }}:</strong>
                <div>{{ $cv['email'] ?? '-' }}</div>
            </div>

            <div>
                <strong>{{ __('frontend.phone') }}:</strong>
                <div>
                    @php
                        $phones = is_array($selectedEmp?->phone)
                            ? $selectedEmp->phone
                            : json_decode($selectedEmp->phone ?? '[]', true);
                    @endphp
                    @foreach ($phones as $phone)
                        @php
                            // نشيل أي مسافات أو رموز
                            $cleanPhone = preg_replace('/\D/', '', $phone);

                            // لو الرقم بيبدأ بـ "0" نشيلها ونضيف +20
                            $hrefPhone = Str::startsWith($cleanPhone, '0')
                                ? '+20' . substr($cleanPhone, 1)
                                : '+20' . $cleanPhone;

                            // للعرض: نخليه شكله 01xxxxxxxx
                            $displayPhone = Str::startsWith($cleanPhone, '0') ? $cleanPhone : '0' . $cleanPhone;
                        @endphp

                        <div>
                            <a href="tel:{{ $hrefPhone }}" class="text-blue-600 hover:underline">
                                {{ $displayPhone }}
                            </a>
                        </div>
                    @endforeach

                </div>
            </div>

            <div>
                <strong>{{ __('frontend.national_id') }}:</strong>
                <div>{{ $selectedEmp?->national_id ?? '-' }}</div>
            </div>

            <div>
                <strong>{{ __('frontend.governorate') }}:</strong>
                <div class="capitalize">
                  {{ $selectedEmp->governorate_name }}
                </div>
              </div>

            <div>
                <strong>{{ __('frontend.birth_date') }}:</strong>
                <div>
                    {{ $selectedEmp?->birth_date
                        ? \Carbon\Carbon::parse($selectedEmp['birth_date'])->translatedFormat('d F Y')
                        : '-' }}  ( {{ $selectedEmp->birth_date->age }}  {{ __('frontend.years') }}  )
                </div>
            </div>

            <div>
                <strong>{{ __('frontend.gender') }}:</strong>
                <div>{{ __('frontend.' . ($selectedEmp?->gender ?? '-')) }}</div>
            </div>

            <div>
                <strong>{{ __('frontend.project') }}:</strong>
                <div>{{ $selectedEmp?->project?->name ?? '-' }}</div>
            </div>



        </div>

        <!-- ID Card Images -->
        @if (!empty($id_card_images))
            <!-- Wrapping ID images and lightbox into a single Alpine component -->
            <div x-data='{
                    lightboxOpen: false,
                    index: 0,
                    images: @json(array_map(fn($img) => asset("storage/{$img}"), $id_card_images)),
                    prev(){ this.index = (this.index-1+this.images.length)%this.images.length },
                    next(){ this.index = (this.index+1)%this.images.length },
                    isPdf(src){ return src.toLowerCase().endsWith(".pdf") }
                }'
                @keydown.escape.window="lightboxOpen = false" class="mt-6">

                <strong class="block mb-2 text-sm font-semibold text-zinc-700 dark:text-zinc-300">
                    {{ __('frontend.documents') }}:
                </strong>

                <!-- Thumbnails -->
                <div class="flex flex-wrap gap-3">
                    @foreach ($id_card_images as $idx => $image)
                        @php $url = asset('storage/' . $image); @endphp
                        <template x-if="!isPdf('{{ $url }}')">
                            <img @click="index = {{ $idx }}; lightboxOpen = true" src="{{ $url }}"
                                alt="ID Image"
                                class="w-20 h-20 object-cover rounded border border-zinc-300 dark:border-zinc-600 shadow cursor-pointer" />
                        </template>
                        <template x-if="isPdf('{{ $url }}')">
                            <div @click="index = {{ $idx }}; lightboxOpen = true"
                                class="flex items-center justify-center w-20 h-20 bg-blue-50 text-blue-600 text-xs font-medium border border-blue-200 rounded cursor-pointer">
                                📄 {{ basename($image) }}
                            </div>
                        </template>
                    @endforeach
                </div>

                <!-- Lightbox Overlay -->
                <div x-show="lightboxOpen" x-cloak x-transition.opacity
                    class="fixed inset-0 bg-black/70 flex items-center justify-center z-[999]">
                    <div @click.away="lightboxOpen = false"
                        class="relative bg-white dark:bg-zinc-900 rounded-lg overflow-hidden max-w-[90vw] max-h-[90vh] p-4">
                        <!-- Close Button -->
                        <button @click="lightboxOpen = false"
                            class="absolute top-2 right-2 text-white bg-gray-800 hover:bg-gray-700 rounded-full p-1 shadow-lg">
                            ✖️
                        </button>

                        <!-- Prev/Next -->
                        <button @click="prev()"
                            class="absolute left-2 top-1/2 -translate-y-1/2 text-2xl text-white p-2 bg-black/50 rounded-full hover:bg-black/70">
                            ‹
                        </button>
                        <button @click="next()"
                            class="absolute right-2 top-1/2 -translate-y-1/2 text-2xl text-white p-2 bg-black/50 rounded-full hover:bg-black/70">
                            ›
                        </button>

                        <!-- Content -->
                        <template x-if="isPdf(images[index])">
                            <div class="flex flex-col items-center justify-center space-y-4 w-full h-[80vh]">
                                <!-- أيقونة PDF كبيرة -->
                                <div class="text-6xl text-red-600">📄</div>
                                <!-- اسم الملف -->
                                <div class="text-base font-medium text-zinc-800 dark:text-zinc-200"
                                    x-text="images[index].split('/').pop()"></div>
                                <!-- زر التحميل -->
                                <a :href="images[index]" :download="images[index].split('/').pop()"
                                    class="px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-md shadow">
                                    🔽 {{ __('frontend.download_pdf') }}
                                </a>
                            </div>
                        </template>
                        <template x-if="!isPdf(images[index])">
                            <img :src="images[index]" class="max-w-full max-h-[80vh] object-contain" alt="Preview" />
                        </template>
                    </div>
                </div>
            </div>

        @endif


        @if (
            !empty($cv_profile_picture) ||
                !empty($cv_experience_roads) ||
                !empty($cv_experience_airports) ||
                !empty($cv_skills))

            <!-- CV Section -->
            <div class="mt-6 space-y-4 border-t border-zinc-200 dark:border-zinc-700 pt-4">
                <h4 class="text-lg font-bold text-zinc-800 dark:text-white">
                    {{ __('frontend.cv_details') }}
                </h4>

                <!-- Profile Picture -->
                @if ($cv_profile_picture)
                    <img src="{{ asset('storage/' . $cv_profile_picture) }}" alt="Profile Picture"
                        class="w-32 h-32 rounded-full object-cover border-4 border-white shadow-lg">
                @endif

                <!-- Experience - Roads -->
                @if (!empty($cv_experience_roads))
                    <div>
                        <strong>{{ __('frontend.roads_experience') }}:</strong>
                        <ul class="list-disc list-inside">
                            @foreach ($cv_experience_roads as $exp)
                                <li>{{ $exp['name'] ?? '-' }} — {{ $exp['start_date'] ?? '' }} →
                                    {{ $exp['end_date'] ?? '' }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <!-- Experience - Airports -->
                @if (!empty($cv_experience_airports))
                    <div>
                        <strong>{{ __('frontend.airports_experience') }}:</strong>
                        <ul class="list-disc list-inside">
                            @foreach ($cv_experience_airports as $exp)
                                <li>{{ $exp['name'] ?? '-' }} — {{ $exp['start_date'] ?? '' }} →
                                    {{ $exp['end_date'] ?? '' }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <!-- Skills -->
                @if (!empty($cv_skills))
                    <div>
                        <strong>{{ __('frontend.skills') }}:</strong>
                        <ul class="list-disc list-inside">
                            @foreach ($cv_skills as $skill)
                                <li>{{ $skill }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <!-- Print CV Button -->
                @if ($selectedEmp?->id)
                    <div class="mt-4">
                        <a href="{{ route('cv.download', ['emp' => encrypt($selectedEmp->id)]) }}" target="_blank"
                            class="px-4 py-2 rounded-md bg-green-600 hover:bg-green-700 text-white text-sm font-semibold shadow">
                            🖨️ {{ __('frontend.print_cv') }}
                        </a>
                    </div>
                @endif
            </div>
        @endif


        <!-- Footer -->
        <div class="mt-6 flex justify-end">
            <button wire:click="closeModal" @click="show = false"
                class="px-4 py-2 bg-gray-500 hover:bg-gray-600 text-white text-sm rounded transition duration-300">
                {{ __('frontend.close') }}
            </button>
        </div>

    </div>
</div>
