<!-- resources/views/livewire/backend/employee/modals/add-more-details.blade.php -->

<div x-data="{ show: true, rate: @entangle('editcv.rate'), hoverRate: 0 }" x-show="show" x-transition:enter="transition ease-out duration-300"
    x-transition:enter-start="opacity-0 scale-90" x-transition:enter-end="opacity-100 scale-100"
    x-transition:leave="transition ease-in duration-200" x-transition:leave-start="opacity-100 scale-100"
    x-transition:leave-end="opacity-0 scale-90" @click.away="$wire.closeModal()"
    class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 px-4 sm:px-6 lg:px-8">

    <div
        class="bg-white dark:bg-zinc-900 rounded-xl shadow-2xl border border-zinc-200 dark:border-zinc-700 w-full max-w-4xl p-6 space-y-6 transition-all duration-300 overflow-y-auto max-h-[90vh]">

        <!-- Header -->
        <div
            class="flex justify-between items-center mb-4 sticky top-0 bg-white dark:bg-zinc-900 z-10 pb-2 border-b border-zinc-200 dark:border-zinc-700">
            <h3 class="text-xl font-bold text-zinc-800 dark:text-white">
                📝 {{ __('backend.add_more_details') }}
            </h3>
            <button @click="show = false; $wire.closeModal()"
                class="text-zinc-500 hover:text-zinc-800 dark:hover:text-white text-2xl leading-none">
                &times;
            </button>
        </div>

        <!-- Form -->
        <form wire:submit.prevent="addmoredetail" class="space-y-6">

            <!-- Contract Type -->
            <div>
                <label for="contract_type" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                    {{ __('backend.contract_type') }}
                </label>
                <select id="contract_type" required
                    class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition"
                    wire:model.defer="editcv.contract_type">
                    <option value="0">{{ __('backend.contract_type') }}</option>
                    <option value="contract">{{ __('backend.contract') }}</option>
                    <option value="serky">{{ __('backend.serky') }}</option>
                </select>
            </div>

            <!-- Grade -->
            <div>
                <label for="grade" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                    {{ __('backend.grade') }}
                </label>
                <input type="number" id="grade" required placeholder="{{ __('backend.grade') }}"
                    class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition"
                    wire:model.defer="editcv.grade" />
            </div>

            <!-- Rate -->
            <div class="flex flex-col items-center">
                <label for="rate" class="block text-lg font-medium text-zinc-700 dark:text-zinc-300 mb-4">
                    {{ __('backend.rate') }}
                </label>
                <div class="flex justify-center space-x-2" id="rate-stars">
                    @for ($i = 1; $i <= 10; $i++)
                        <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 24 24"
                            class="w-12 h-12 cursor-pointer text-gray-400 hover:text-yellow-500 transition"
                            :class="{ 'text-yellow-500': rate >= {{ $i }} }"
                            @click="rate = {{ $i }}; $wire.set('editcv.rate', rate)"
                            @mouseover="hoverRate = {{ $i }}" @mouseleave="hoverRate = rate">
                            <path
                                d="M12 .587l3.668 7.431 8.2 1.192-5.934 5.782 1.4 8.168L12 18.896l-7.334 3.864 1.4-8.168L.166 9.21l8.2-1.192z" />
                        </svg>
                    @endfor
                </div>
                <input type="hidden" id="rate" wire:model.defer="editcv.rate" x-model="rate" />
            </div>

            <!-- Submit Button -->
            <div class="flex justify-end mt-6">
                <button type="submit"
                    class="px-5 py-2 bg-green-600 text-white font-medium rounded-lg hover:bg-green-700 transition-all duration-300">
                    🚀 {{ __('frontend.submit') }}
                </button>
            </div>

        </form>
    </div>
</div>
