<?php

use App\Models\System\SystemParent;
use App\Models\System\SystemRoute;
use App\Helpers\AppSettings;
use Illuminate\Support\Facades\Auth;
use Livewire\Volt\Component;
use Livewire\Attributes\On;

new class extends Component {
    public $menu = [];
    public $selectedChild;

    public function mount()
    {
        $lang = AppSettings::language();
        $user = Auth::user();
        $userPagesRaw = $user->pages['page'] ?? [];
        $userPages = is_array($userPagesRaw) ? $userPagesRaw : [$userPagesRaw];
        $currentRouteName = request()->route()->getName();
        $selectedChildKey = null;
        // 🧩 1. جلب الـ Routes الفعالة + اللي فيها parent_id
        $routes = SystemRoute::where('is_active', true)
            ->get()
            ->filter(function ($route) use ($userPages) {
                if (!isset($route->parent_id)) {
                    return false;
                }
                if ($route->name === 'dashboard') {
                    return true;
                }
                if (in_array('[all]', $userPages)) {
                    return true;
                }

                return in_array($route->name, $userPages);
            });

        // 🧩 2. Group Routes: parent_id = 0
        $groupRoutes = $routes
            ->filter(function ($route) {
                return (int) $route->parent_id === 0;
            })
            ->map(function ($route) use ($lang, $routes, $currentRouteName, &$selectedChildKey) {
                $props = is_array($route->route_properties) ? $route->route_properties : json_decode($route->route_properties, true);

                $groupIconName = $props['display_icon'] ?? 'folder';
                $groupIconSvg = file_exists(resource_path("icons/{$groupIconName}.svg")) ? file_get_contents(resource_path("icons/{$groupIconName}.svg")) : '<svg class="w-5 h-5 text-gray-400" fill="none"><circle cx="12" cy="12" r="10" stroke="currentColor"/></svg>';

                $children = $routes
                    ->filter(function ($child) use ($route) {
                        return (int) $route->parent_id === (int) $route->id;
                    })
                    ->sortBy(function ($c) {
                        return $route->order ?? PHP_INT_MAX;
                    })
                    ->map(function ($route) use ($lang, $currentRouteName, &$selectedChildKey) {
                        $props = is_array($route->route_properties) ? $route->route_properties : json_decode($route->route_properties, true);
                        $iconName = $props['display_icon'] ?? 'circle';
                        $iconSvg = file_exists(resource_path("icons/{$iconName}.svg")) ? file_get_contents(resource_path("icons/{$iconName}.svg")) : '<svg class="w-5 h-5 text-gray-400" fill="none"><circle cx="12" cy="12" r="10" stroke="currentColor"/></svg>';
                        if ($route->name === $currentRouteName) {
                            $selectedChildKey = route($route->name);
                        }
                        return [
                            'key' => 'r-' . $route->name,
                            'title' => $props['display_name'][$lang] ?? $route->name,
                            'route' => route($route->name),
                            'icon' => $iconSvg,
                        ];
                    })
                    ->values()
                    ->toArray();

                return [
                    'key' => 'r-' . $route->name,
                    'title' => $props['display_name'][$lang] ?? $route->name,
                    'icon' => $groupIconSvg,
                    'route' => route($route->name),
                    'children' => $children,
                    'source' => 'route',
                    'order' => $route->order ?? PHP_INT_MAX,
                    '_open' => collect($children)->contains(fn($child) => $child['route'] === route($currentRouteName)),
                ];
            });

        // 🧩 3. system_parents
        $systemParents = SystemParent::orderByRaw('ISNULL([order], ?) ASC', 2147483647)->get();

        $parentGroups = $systemParents
        ->map(function ($parent) use ($routes, $lang, $currentRouteName, &$selectedChildKey) {
                $children = $routes
                    ->filter(function ($route) use ($parent) {
                        return (int) $route->parent_id === (int) $parent->id;
                    })
                    ->sortBy(function ($c) {
                        return $route->order ?? PHP_INT_MAX;
                    })
                    ->map(function ($route) use ($lang, $currentRouteName, &$selectedChildKey) {
                        $props = is_array($route->route_properties) ? $route->route_properties : json_decode($route->route_properties, true);
                        $iconName = $props['display_icon'] ?? 'circle';
                        $iconSvg = file_exists(resource_path("icons/{$iconName}.svg")) ? file_get_contents(resource_path("icons/{$iconName}.svg")) : '<svg class="w-5 h-5 text-gray-400" fill="none"><circle cx="12" cy="12" r="10" stroke="currentColor"/></svg>';
                        if ($route->name === $currentRouteName) {
                            $selectedChildKey = route($route->name);
                        }
                        return [
                            'key' => 'r-' . $route->name,
                            'title' => $props['display_name'][$lang] ?? $route->name,
                            'route' => route($route->name),
                            'icon' => $iconSvg,
                        ];
                    })
                    ->values()
                    ->toArray();

                if (count($children) === 0) {
                    return null;
                }

                $groupIconName = $parent->icon ?? 'folder';
                $groupIconSvg = file_exists(resource_path("icons/{$groupIconName}.svg")) ? file_get_contents(resource_path("icons/{$groupIconName}.svg")) : '<svg class="w-5 h-5 text-gray-400" fill="none"><circle cx="12" cy="12" r="10" stroke="currentColor"/></svg>';

                return [
                    'key' => 'p-' . $parent->id,
                    'title' => $lang === 'ar' ? $parent->name_ar : $parent->name_en,
                    'icon' => $groupIconSvg,
                    'route' => '#',
                    'children' => $children,
                    'source' => 'parent',
                    'order' => $parent->order ?? PHP_INT_MAX,
                    '_open' => collect($children)->contains(fn($child) => $child['route'] === route($currentRouteName)),
                ];
            })
            ->filter();

        // 🧩 4. دمج الكل + ترتيب موحد
        $menu = $groupRoutes->concat($parentGroups)->sortBy(fn($item) => $item['order'] ?? PHP_INT_MAX)->values();

        $this->menu = json_decode(json_encode($menu, JSON_UNESCAPED_UNICODE), true);
        $this->selectedChild = $selectedChildKey;
    }
};

?>

<div x-data="{
    locale: @js($lang),
    selectedChild: @js($selectedChild),
    menu: @js($menu),
    dir: document.dir
}">
    @php
        $user = Auth::user();
        $job =
            $lang === 'ar'
                ? optional($user->employee->jobTitle)->title_ar
                : optional($user->employee->jobTitle)->title_en;

        $job = $job ?? ($lang === 'ar' ? 'موظف' : 'Employee');

        $jobShort = mb_strtoupper(mb_substr($job, 0, 2));
        $sidebarFullText = '🌊 ' . $job;
        $sidebarShortText = '🌊 ' . $jobShort;
    @endphp


    <aside x-transition:enter="transition-all duration-500 ease-in-out" x-transition:enter-start="opacity-0 scale-95"
        x-transition:enter-end="opacity-100 scale-100" x-transition:leave="transition-all duration-300 ease-in-out"
        x-transition:leave-start="opacity-100 scale-100" x-transition:leave-end="opacity-0 scale-95"
        :class="sidebarOpen ? 'w-64' : 'w-20'"
        class="transition-[width] duration-500 ease-in-out hidden md:block fixed top-0 bottom-0 z-40 bg-white/80 dark:bg-zinc-900/70 shadow-2xl backdrop-blur-md border-e border-indigo-200 dark:border-indigo-700/40 h-full flex-shrink-0 ">
        <!-- الشعار -->
        <div class="px-4 pt-4 pb-2">
            <h1 class="font-bold tracking-wide"
                :class="[
                    sidebarOpen ? 'text-2xl scale-100 opacity-100 text-start' :
                    'text-sm scale-90 opacity-70 text-center',
                    'transition-all duration-500 whitespace-nowrap'
                ]"
                x-data="{ fullText: '{{ $sidebarFullText }}', shortText: '{{ $sidebarShortText }}' }" x-text="sidebarOpen ? fullText : shortText"></h1>

        </div>

        <!-- زر الانكماش -->
        <div class="flex p-3 z-50 relative" rtl:justify-start ltr:justify-end>
            <button @click="sidebarOpen = !sidebarOpen; localStorage.setItem('sidebarOpen', sidebarOpen)"
                @mouseenter="hovering = true" @mouseleave="hovering = false" x-data="{ hovering: false }"
                :class="[
                    'absolute top-4 z-50 w-9 h-9 rounded-full flex items-center justify-center transition-all duration-300',
                    'bg-indigo-100/80 hover:bg-indigo-200 dark:bg-indigo-900/40 dark:hover:bg-indigo-800 shadow-md',
                    dir === 'rtl' ?
                    (sidebarOpen ? 'translate-x-1 left-0' : 'translate-x-2 left-0') :
                    (sidebarOpen ? '-translate-x-1 right-0' : '-translate-x-2 right-0'),
                    hovering ? 'scale-150' : ''
                ]">
                <svg :class="[
                    'w-5 h-5 text-indigo-700 dark:text-indigo-300 transition-transform duration-300 ease-in-out',
                    sidebarOpen ? 'rotate-180' : 'rotate-0',
                    dir === 'rtl' ? '-scale-x-100' : ''
                ]"
                    fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 5l7 7-7 7" />
                </svg>
                <span
                    class="absolute inset-0 rounded-full ring-2 ring-indigo-300 dark:ring-indigo-700
              opacity-20 blur-sm pointer-events-none transition-all duration-300 group-hover:opacity-40"></span>
            </button>

        </div>
        <div class="h-12"></div>




        <!-- القائمة -->
        <nav class="mt-4 space-y-2 px-2">
            <template x-for="item in menu" :key="item.key">
                <div class="relative" @click.away="item._open = false">
                    <a :href="item.children.length ? '#' : item.route"
                        @click.prevent="item.children.length ? (item._open = !item._open) : window.location.href = item.route"
                        class="flex items-center gap-3 px-4 py-2 rounded-lg transition-all duration-300 justify-between"
                        :class="[
                            item._open ?
                            'bg-indigo-200/70 dark:bg-indigo-700/30 ring-1 ring-indigo-300 dark:ring-indigo-600' :
                            'hover:bg-indigo-100 dark:hover:bg-zinc-800 text-gray-800 dark:text-gray-100',

                        ]"
                        rtl:flex-row-reverse ltr:flex-row>
                        <!-- الآيقون والعنوان -->
                        <div class="flex items-center gap-3 flex-1"
                            :class="{
                                'justify-center': !sidebarOpen
                            }">
                            <span class="text-xl transition-transform duration-300"
                                :class="sidebarOpen ? 'rotate-0 scale-100' : 'rotate-6 scale-90'"
                                x-html="item.icon"></span>
                            <span x-show="sidebarOpen" x-cloak x-text="item.title"
                                class="transition-all duration-300 opacity-100 scale-100"
                                :class="!sidebarOpen ? 'opacity-0 scale-95' : 'opacity-100 scale-100'"></span>
                        </div>

                        <!-- السهم -->
                        <template x-if="item.children.length">
                            <svg class="w-4 h-4 text-gray-400 transition-transform duration-300"
                                :class="{
                                    'rotate-180': item._open
                                }"
                                fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7" />
                            </svg>
                        </template>
                    </a>


                    <!-- القائمة الفرعية -->
                    <div x-show="item._open" x-transition:enter="transition ease-out duration-300 delay-100"
                        x-transition:enter-start="opacity-0 scale-95 -translate-y-2"
                        x-transition:enter-end="opacity-100 scale-100 translate-y-0"
                        x-transition:leave="transition transform ease-in duration-200"
                        x-transition:leave-start="opacity-100 scale-100 translate-y-0"
                        x-transition:leave-end="opacity-0 scale-95 -translate-y-2"
                        class="overflow-hidden mt-1 space-y-1 text-sm text-gray-600 dark:text-gray-300"
                        :class="[
                            sidebarOpen ?
                            'ps-10' :
                            'absolute top-1/2 transform -translate-y-1/2 w-52 bg-white dark:bg-zinc-800 rounded-md shadow-xl p-2 z-50',
                            dir === 'rtl' ? 'right-full me-2' : 'left-full ms-2'
                        ]">
                        <template x-for="child in item.children" :key="child.route">
                            <a :href="child.route" class="block py-1 px-3 rounded transition-all"
                                :class="child.route === selectedChild ?
                                    'bg-indigo-200/60 dark:bg-indigo-700/40 text-indigo-800 dark:text-indigo-100 ring-1 ring-indigo-300 dark:ring-indigo-600' :
                                    'hover:text-indigo-600 hover:ps-3 text-gray-600 dark:text-gray-300'">
                                <span class="inline-flex items-center gap-2">
                                    <span class="text-base" x-html="child.icon"></span>
                                    <span x-text="child.title"></span>
                                </span>
                            </a>
                        </template>
                    </div>
                </div>
            </template>
        </nav>
    </aside>
</div>
