<?php

use Livewire\Volt\Component;
use Livewire\Attributes\On;

new class extends Component {
    public function toggleLock()
    {
        $user = Auth::user();
        $settings = $user->settings ?? [];

        // اقلب قيمة is_locked
        $settings['is_locked'] = !($settings['is_locked'] ?? false);

        $user->settings = $settings;
        $user->save();

        // لو حابب تحدث القيمة في Alpine تلقائيًا
        $this->dispatch('lock-status-updated', value: $settings['is_locked']);
        session()->flash('toast', [
            'type' => 'success',
            'msg' => __('backend.login_success'),
            'duration' => 5000,
        ]);

        $this->redirectIntended(default: route('lock.screen', absolute: false), navigate: true);
    }
};
?>
<div x-data="{ dir: document.dir }" x-init="dir = document.dir">
    @php
        $user = Auth::user();
        $avatar = $user->settings['avatar'] ?? null;
        $name = $user->name ?? null;
        $initials = strtoupper(mb_substr($user->name, 0, 2));
    @endphp


    <header class="fixed top-0 inset-x-0 z-50 transition-all duration-700" :class="{ '-translate-y-full': hidden }">
        <nav :class="sidebarOpen ? 'md:ms-64' : 'md:ms-20'"
            class="mx-auto flex items-center justify-between p-4 transition-all duration-500 relative bg-white/80 dark:bg-zinc-900/70 shadow-md backdrop-blur-md rounded-b-xl">

            <!-- الشعار -->
            <div class="flex items-center gap-2 text-xl font-bold tracking-wide">
                <img src="/assets/img/logo.png" alt="Logo" class="h-8 w-auto" />
            </div>
            <!-- عناصر التفاعل -->
            <div class="flex items-center gap-4" :class="dir === 'rtl' ? 'flex-row-reverse' : 'flex-row'">

                <!-- أزرار اللغة + الثيم + الرسائل + الإشعارات (ديسكتوب فقط) -->
                <div class="flex flex-wrap items-center gap-2 md:gap-4 lg:gap-5 xl:gap-6 2xl:gap-8">
                    <!-- زر اللغة -->
                    @php
                        $shouldFetchLang = Auth::check();
                    @endphp

                    <script>
                        function switchLanguage(currentDir, shouldFetch) {
                            const target = currentDir === 'rtl' ? 'en' : 'ar';
                            localStorage.setItem('lang', target);

                            if (shouldFetch === true) {
                                fetch(`/set-language/${target}`);
                            }

                            // إعادة تحميل الصفحة فقط بعد التغيير
                            setTimeout(() => {
                                window.location.reload();
                            }, 100);
                        }
                    </script>
                    <div class="hidden md:flex">
                        <button x-data="{ isSwitchingLang: false }" :disabled="isSwitchingLang"
                            @click="isSwitchingLang = true; switchLanguage(dir, {{ Auth::check() ? 'true' : 'false' }})"
                            class=" ms-2 me-2 flex items-center gap-2 text-sm font-medium transition hover:underline disabled:opacity-50 disabled:cursor-not-allowed">
                            <img :src="dir === 'rtl' ? 'https://flagcdn.com/w40/gb.png' : 'https://flagcdn.com/w40/eg.png'"
                                class="w-5 h-5 rounded-sm" />

                            <template x-if="!isSwitchingLang">
                                <span x-text="dir === 'rtl' ? 'English' : 'عربي'"></span>
                            </template>

                            <template x-if="isSwitchingLang">
                                <svg class="animate-spin h-4 w-4 text-indigo-600" fill="none" viewBox="0 0 24 24">
                                    <circle class="opacity-25" cx="12" cy="12" r="10"
                                        stroke="currentColor" stroke-width="4" />
                                    <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v8H4z" />
                                </svg>
                            </template>
                        </button>


                        <!-- زر الثيم -->
                        <button @click="toggleTheme()" class=" ms-2 me-2">
                            <span x-text="darkMode ? '☀️ Light' : '🌙 Dark'"></span>
                        </button>

                        <!-- زر الرسائل -->
                        {{-- <div x-data="{ desktopMsgOpen: false }" class="relative  ms-3 me-3">
                            <button @click="desktopMsgOpen = !desktopMsgOpen"
                                class="text-xl transition hover:scale-110">
                                📩
                            </button>

                            <div x-show="desktopMsgOpen" @click.outside="desktopMsgOpen = false" x-transition
                                class="absolute top-full mt-3 w-[90vw] sm:w-[320px] max-w-[90vw] bg-white dark:bg-zinc-800 p-4 rounded-2xl shadow-2xl ring-1 ring-black/10 dark:ring-white/10 z-50"
                                :class="dir === 'rtl' ? 'left-0' : 'right-0'">

                                <!-- عنوان -->
                                <div class="flex items-center justify-between mb-2">
                                    <h2 class="text-base font-semibold text-zinc-800 dark:text-white">
                                        {{ __('backend.recent_messages') }}
                                    </h2>
                                    <button @click="desktopMsgOpen = false"
                                        class="text-zinc-500 hover:text-red-500 transition text-sm">
                                        ✕
                                    </button>
                                </div>

                                <!-- رسائل -->
                                <template x-for="msg in messages.slice(0, 3)" :key="msg.id">
                                    <div
                                        class="flex items-start gap-3 p-3 rounded-lg hover:bg-zinc-100 dark:hover:bg-zinc-700 transition cursor-pointer">
                                        <img :src="msg.avatar"
                                            class="w-10 h-10 rounded-full shadow-sm object-cover" />
                                        <div class="flex-1 min-w-0">
                                            <h3 class="text-sm font-bold text-zinc-800 dark:text-white truncate"
                                                x-text="msg.name"></h3>
                                            <p class="text-xs text-zinc-500 dark:text-zinc-300 truncate"
                                                x-text="msg.subject"></p>
                                            <p class="text-xs text-zinc-400 dark:text-zinc-500 line-clamp-2"
                                                x-text="msg.text"></p>
                                        </div>
                                    </div>
                                </template>

                                <!-- زر مشاهدة الكل -->
                                <div class="mt-3 pt-2 border-t border-zinc-200 dark:border-zinc-700 text-center">
                                    <a href="#"
                                        class="text-sm font-medium text-indigo-600 dark:text-indigo-400 hover:underline transition">
                                        {{ __('backend.view_all') }}
                                    </a>
                                </div>
                            </div>
                        </div> --}}



                        <!-- زر الإشعارات -->
                        {{-- <div x-data="{ desktopNotiOpen: false }" class="relative">
                            <button @click="desktopNotiOpen = !desktopNotiOpen"
                                class="text-xl transition hover:scale-110">
                                🔔
                            </button>

                            <div x-show="desktopNotiOpen" @click.outside="desktopNotiOpen = false" x-transition
                                class="absolute top-full mt-3 w-[90vw] sm:w-[320px] max-w-[90vw] bg-white dark:bg-zinc-800 p-4 rounded-2xl shadow-2xl ring-1 ring-black/10 dark:ring-white/10 z-50"
                                :class="dir === 'rtl' ? 'left-0' : 'right-0'">

                                <!-- العنوان -->
                                <div class="flex items-center justify-between mb-2">
                                    <h2 class="text-base font-semibold text-zinc-800 dark:text-white">
                                        {{ __('backend.notifications') }}
                                    </h2>
                                    <button @click="desktopNotiOpen = false"
                                        class="text-zinc-500 hover:text-red-500 transition text-sm">
                                        ✕
                                    </button>
                                </div>

                                <!-- التنبيهات -->
                                <template x-for="noti in notifications.slice(0, 3)" :key="noti.id">
                                    <div
                                        class="flex items-start gap-3 p-3 rounded-lg hover:bg-zinc-100 dark:hover:bg-zinc-700 transition cursor-pointer">
                                        <div class="w-10 h-10 flex items-center justify-center rounded-full shrink-0"
                                            :class="{
                                                'bg-blue-200 text-blue-800': noti.type === 'info',
                                                'bg-yellow-200 text-yellow-800': noti.type === 'warning',
                                                'bg-red-200 text-red-800': noti.type === 'error'
                                            }">
                                            <span x-text="noti.icon"></span>
                                        </div>
                                        <div class="flex-1 min-w-0">
                                            <h3 class="text-sm font-bold text-zinc-800 dark:text-white truncate"
                                                x-text="noti.title"></h3>
                                            <p class="text-xs text-zinc-500 dark:text-zinc-300 line-clamp-2"
                                                x-text="noti.text"></p>
                                        </div>
                                    </div>
                                </template>

                                <!-- زر مشاهدة الكل -->
                                <div class="mt-3 pt-2 border-t border-zinc-200 dark:border-zinc-700 text-center">
                                    <a href="#"
                                        class="text-sm font-medium text-indigo-600 dark:text-indigo-400 hover:underline transition">
                                        {{ __('backend.view_all') }}
                                    </a>
                                </div>
                            </div>
                        </div> --}}
                    </div>

                    <!-- البروفايل والقفل -->
                    <div x-data="{ open: false, locked: @js(Auth::user()->settings['is_locked'] ?? false) }" class="relative inline-flex items-center gap-3">

                        <!-- البروفايل: صورة أو حروف + اسم -->
                        <div @click="open = !open"
                            class="flex items-center gap-1 sm:gap-2 cursor-pointer focus:outline-none transition">

                            @php
                                $user = Auth::user();
                                $locale = app()->getLocale();
                                $employee = $user->employee;

                                // الاسم الكامل حسب اللغة (لو مش موجود fallback على name)
                                $fullName = $employee?->full_name[$locale] ?? $user->name;

                                // نجيب أول كلمتين للاستخدام الكامل
                                $nameParts = explode(' ', trim($fullName));
                                $fullNameDisplay = implode(' ', array_slice($nameParts, 0, 2)); // أول كلمتين

                                // لو في كلمة واحدة بس نحطها في short، غير كده نعرض الكلمة الأولى فقط
                                $shortName = $nameParts[0] ?? $user->name;
                                $avatarPath = $user->settings['avatar'] ?? null;
                                $avatar = $avatarPath ? asset('storage/' . $avatarPath) : null;
                                $initials = strtoupper(Str::substr($user->name, 0, 2));
                            @endphp


                            <div x-data="{ avatar: '{{ $avatar }}', initials: '{{ $initials }}' }" x-init="    window.addEventListener('avatarUpdated', e => {
                                    avatar = e.detail ? e.detail + '?t=' + new Date().getTime() : null;
                                });
                                window.addEventListener('updateInitials', e => {
                                    console.log('updateInitials received', e.detail);
                                    initials = (e.detail !== null && e.detail !== undefined) ? e.detail.trim() : '{{ $initials }}';
                                });" class="relative">


                                <!-- صورة المستخدم -->

                                <img x-show="avatar && avatar.length > 5" :src="avatar" alt="Avatar"
                                    class="w-8 h-8 sm:w-10 sm:h-10 rounded-full tiny-avatar ring-2 ring-indigo-300 dark:ring-indigo-700 object-cover shadow-sm transition hover:scale-110" />


                                <!-- الحروف الأولى لو مفيش صورة -->

                                <div x-show="!avatar || String(avatar).length <= 5"
                                    class="w-8 h-8 sm:w-10 sm:h-10 flex items-center justify-center rounded-full bg-indigo-500 text-white text-xs sm:text-sm font-bold uppercase ring-2 ring-indigo-300 dark:ring-indigo-700 transition hover:scale-110">
                                    <span x-text="initials"></span>
                                </div>

                                <!-- خلفية نبض -->
                                <div
                                    class="absolute inset-0 rounded-full bg-indigo-300 dark:bg-indigo-600 opacity-30 blur-md animate-pulse pointer-events-none">
                                </div>
                            </div>

                            <span x-data="{
                                name: '{{ $fullNameDisplay }}',
                                short: '{{ $shortName }}'
                            }" x-init="window.addEventListener('nameUpdated', e => name = e.detail)"
                                class="font-medium leading-none text-zinc-800 dark:text-white text-xs sm:text-sm">
                                <!-- عرض مختصر للموبايل -->
                                <span class="inline sm:hidden" x-text="short.trim()"></span>

                                <!-- عرض كامل للديسكتوب -->
                                <span class="hidden sm:inline" x-text="name"></span>
                            </span>


                        </div>

                        <!-- زر القفل -->
                        <div x-data="{
                            locked: @js(Auth::user()->settings['is_locked'] ?? false),
                            isToggling: false
                        }" @lock-status-updated.window="locked = $event.detail.value">

                            <button
                                @click.stop="
                                if (isToggling) return;
                                isToggling = true;
                                $wire.toggleLock();
                                setTimeout(() => isToggling = false, 2000);
                            "
                                :disabled="isToggling"
                                class="focus:outline-none transition relative disabled:opacity-50 disabled:cursor-not-allowed">
                                <span :class="locked ? 'text-red-500 rotate-0' : 'text-green-500 rotate-45'"
                                    class="text-xl transition-transform duration-300">

                                    <template x-if="locked">
                                        <!-- أيقونة القفل المقفول -->
                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6" fill="currentColor"
                                            viewBox="0 0 24 24">
                                            <path
                                                d="M12 1a5 5 0 00-5 5v4H5a1 1 0 000 2h14a1 1 0 100-2h-2V6a5 5 0 00-5-5zm-3 5a3 3 0 016 0v4H9V6z" />
                                            <path
                                                d="M5 13a3 3 0 00-3 3v5a3 3 0 003 3h14a3 3 0 003-3v-5a3 3 0 00-3-3H5z" />
                                        </svg>
                                    </template>

                                    <template x-if="!locked">
                                        <!-- أيقونة القفل المفتوح -->
                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6" fill="currentColor"
                                            viewBox="0 0 24 24">
                                            <path
                                                d="M17 8V7a5 5 0 00-10 0v1H5a1 1 0 000 2v10a1 1 0 001 1h14a1 1 0 001-1V9a1 1 0 000-2h-2zM9 7a3 3 0 016 0v1H9V7z" />
                                        </svg>
                                    </template>
                                </span>

                                <!-- لودينج صغير على الزر أثناء الانتظار -->
                                <template x-if="isToggling">
                                    <div class="absolute top-0 end-0 -mt-1 -me-1 animate-spin">
                                        <svg class="w-4 h-4 text-indigo-500" fill="none" viewBox="0 0 24 24">
                                            <circle class="opacity-25" cx="12" cy="12" r="10"
                                                stroke="currentColor" stroke-width="4" />
                                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v8H4z" />
                                        </svg>
                                    </div>
                                </template>
                            </button>
                        </div>

                        <!-- Dropdown -->
                        <div x-cloak x-show="open" @click.outside="open = false" x-transition
                            class="absolute top-full mt-3 w-[250px] bg-white dark:bg-zinc-800 rounded-2xl shadow-2xl ring-1 ring-black/10 dark:ring-white/10 z-50"
                            :class="dir === 'rtl' ? 'left-0' : 'right-0'">

                            <a href="{{ route('user-profile') }}"
                                class="flex items-center gap-2 px-4 py-2 text-sm text-zinc-700 dark:text-white hover:bg-zinc-100 dark:hover:bg-zinc-700 transition">
                                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-indigo-600" fill="none"
                                    viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M5.121 17.804A4.992 4.992 0 0112 15c1.657 0 3.156.672 4.121 1.804M15 11a3 3 0 10-6 0 3 3 0 006 0z" />
                                </svg>
                                {{ __('backend.profile') }}
                            </a>

                            {{-- <a href="#"
                                class="flex items-center gap-2 px-4 py-2 text-sm text-zinc-700 dark:text-white hover:bg-zinc-100 dark:hover:bg-zinc-700 transition">
                                <svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6 text-indigo-600 animate-spin"
                                    fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                                {{ __('backend.settings') }}
                            </a> --}}

                            <form method="POST" action="{{ route('logout') }}">
                                @csrf
                                <button type="submit"
                                    class="w-full text-start flex items-center gap-2 px-4 py-2 text-sm text-red-500 hover:bg-red-50 dark:hover:bg-zinc-700 transition">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-red-500"
                                        fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M17 16l4-4m0 0l-4-4m4 4H7" />
                                    </svg>
                                    {{ __('frontend.logout') }}
                                </button>
                            </form>
                        </div>
                    </div>


                    <!-- زر إخفاء النافبار -->
                    <button @click="hidden = !hidden; localStorage.setItem('navbarHidden', hidden)" class="group">
                        <div
                            class="w-10 h-10 rounded-full tiny-button bg-white dark:bg-zinc-800 shadow-lg ring-4 ring-indigo-300 dark:ring-indigo-700 flex items-center justify-center transition-all duration-500 group-hover:scale-110 animate-fade-bounce">
                            <svg class="w-5 h-5 text-indigo-600 dark:text-indigo-300 transition-transform duration-300"
                                :class="{ 'rotate-180': hidden }" fill="none" stroke="currentColor"
                                stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M5 15l7-7 7 7" />
                            </svg>
                        </div>
                    </button>


                    <!-- زر الموبايل همبورغر -->
                    <div class="flex md:hidden  ms-3 me-3">
                        <button @click="submenuMenuOpen = !submenuMenuOpen"
                            class="relative flex items-center justify-center w-12 h-12 rounded-full tiny-button
                            bg-indigo-100 dark:bg-zinc-700 shadow-lg ring-2 ring-indigo-300 dark:ring-indigo-600
                            transition-all duration-300 hover:scale-110 hover:ring-4 hover:bg-indigo-200 dark:hover:bg-zinc-600
                            animate-fade-bounce">
                            <!-- أيقونة الهمبورغر -->
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6 text-indigo-700 dark:text-white"
                                fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M4 6h16M4 12h16M4 18h16" />
                            </svg>

                            <!-- خلفية نبض خفيف -->
                            <div
                                class="absolute inset-0 rounded-full bg-indigo-300 dark:bg-indigo-600 opacity-10 blur-sm animate-pulse pointer-events-none">
                            </div>
                        </button>
                    </div>


                </div>

        </nav>
    </header>



    <!-- زر لإظهار الـ Navbar مرة أخرى إذا كانت مخفية -->
    <button @click="hidden = !hidden" x-show="hidden" x-transition
        class="fixed top-4 end-4 z-[60] group transition-all duration-700">
        <div
            class="w-12 h-12 rounded-full bg-white dark:bg-zinc-800 shadow-lg ring-4 ring-indigo-300 dark:ring-indigo-700 flex items-center justify-center transition-all duration-500 group-hover:scale-110 animate-fade-bounce">
            <svg class="w-6 h-6 text-indigo-600 dark:text-indigo-300 transition-transform duration-300 rotate-180"
                fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M5 15l7-7 7 7" />
            </svg>
        </div>
    </button>
</div>
