<?php

use App\Livewire\Actions\Logout;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Livewire\Attributes\Layout;
use Livewire\Volt\Component;
use Illuminate\View\View;

new #[Layout('components.frontend.layouts.struct')] class extends Component {

public function rendering(View $view): void
    {
        $view->title(__('frontend.tittlewelcomepage') .' | '.__('frontend.verify_title'));
    }
    /**
     * Send an email verification notification to the user.
     */
    public function sendVerification(): void
    {
        if (Auth::user()->hasVerifiedEmail()) {
            $this->redirectIntended(default: route('dashboard', absolute: false), navigate: true);

            return;
        }

        Auth::user()->sendEmailVerificationNotification();

        Session::flash('status', 'verification-link-sent');
    }

    /**
     * Log the current user out of the application.
     */
    public function logout(Logout $logout): void
    {
        $logout();

        $this->redirect('/', navigate: true);
    }
}; ?>

<div class="min-h-screen flex items-center justify-center bg-transparent transition duration-700 overflow-hidden relative">

    <div class="z-10 max-w-md w-full space-y-6 bg-white/80 dark:bg-zinc-900/80 backdrop-blur-md p-8 rounded-xl shadow-2xl border border-zinc-300 dark:border-zinc-700">

        <!-- ✉️ الشعار والعنوان -->
        <div class="flex flex-col items-center gap-2 animate-fade-in-down">
            <img src="/assets/img/logo.png" alt="Logo" class="w-[300px] h-auto mb-3 drop-shadow-lg" />
            <h2 class="text-2xl font-semibold text-zinc-800 dark:text-white">
                {{ __('frontend.verify_title') }}
            </h2>
            <p class="text-sm text-zinc-500 dark:text-zinc-400 text-center">
                {{ __('frontend.verify_msg') }}
            </p>
        </div>

        <!-- ✅ إشعار تم الإرسال -->
        @if (session('status') == 'verification-link-sent')
            <p class="text-center font-medium text-green-600 dark:text-green-400 animate-fade-in">
                {{ __('frontend.verify_sent') }}
            </p>
        @endif

        <!-- 🔁 الأزرار -->
        <div class="flex flex-col gap-4 mt-4 animate-fade-in-down">
            <button wire:click="sendVerification" class="neon-btn neon-blue w-full delay-[300ms]">
                <span class="btn-text">{{ __('frontend.resend_link') }}</span>
                <span class="glow"></span>
            </button>

            <button wire:click="logout" class="text-sm text-zinc-600 dark:text-zinc-300 hover:underline text-center">
                {{ __('frontend.logout') }}
            </button>
        </div>

    </div>
</div>

