<?php



use Livewire\Attributes\Layout;
use Livewire\Volt\Component;
use Illuminate\View\View;

new #[Layout('components.frontend.layouts.struct')] class extends Component {
    public function rendering(View $view): void
    {
        $view->title(__('frontend.tittlewelcomepage') .' | '.__('frontend.account_review_title'));
    }

    public function boot()
    {

    }

};
?>

<div class="z-10 max-w-md w-full bg-white/80 dark:bg-zinc-900/80 backdrop-blur-md
    p-8 rounded-2xl shadow-lg dark:shadow-md border border-zinc-300 dark:border-zinc-700
    text-center space-y-6">

    <!-- توهج خلف القفل -->
    <div class="absolute w-[300px] h-[300px] rounded-full blur-[120px] opacity-20
        bg-gradient-to-br from-indigo-400 via-purple-500 to-pink-400
        dark:from-indigo-300 dark:via-purple-600 dark:to-pink-500 animate-pulse -translate-x-1/2 -translate-y-1/2 top-1/2 left-1/2 z-0">
    </div>

    <!-- محتوى الصفحة -->
    <div class="z-10 max-w-md w-full bg-white/80 dark:bg-zinc-900/80 backdrop-blur-md
        p-8 rounded-2xl shadow-2xl border border-zinc-300 dark:border-zinc-700
        text-center space-y-6">

        <!-- 🔒 أيقونة القفل -->
        <div class="relative flex justify-center items-center">
            <div class="absolute w-[200px] h-[200px] rounded-full blur-[90px] opacity-30
                bg-gradient-to-br from-indigo-400 via-purple-500 to-pink-400
                dark:from-indigo-300 dark:via-purple-600 dark:to-pink-500 animate-pulse">
            </div>

            <div class="relative p-4 rounded-full border border-indigo-400 dark:border-purple-500
                bg-white/20 dark:bg-black/20 backdrop-blur-sm shadow-[0_0_20px_#818cf8]
                dark:shadow-[0_0_25px_#9333ea] animate-neon-glow">
                <svg class="w-24 h-24 text-indigo-500 dark:text-purple-400" viewBox="0 0 24 24" fill="none"
                     stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round">
                    <rect x="3" y="11" width="18" height="11" rx="2" ry="2" />
                    <path d="M7 11V7a5 5 0 0110 0v4" />
                </svg>
            </div>
        </div>

        <!-- 📝 العنوان -->
        <h2 class="text-2xl font-bold text-zinc-800 dark:text-white">
            {{ __('frontend.account_review_title') }}
        </h2>

        <!-- 💬 الرسالة -->
        <p class="text-sm text-zinc-600 dark:text-zinc-300 leading-relaxed">
            {{ __('frontend.account_review_msg') }}
        </p>


        <!-- 🚪 زر تسجيل الخروج -->
        <form method="POST" action="{{ route('logout') }}">
            @csrf
            <button type="submit"
                class="w-full py-2 rounded-lg font-semibold transition-all duration-300
                       bg-red-500 hover:bg-red-600 text-white
                       dark:bg-red-400 dark:hover:bg-red-500 dark:text-black
                       shadow-[0_0_12px_rgba(239,68,68,0.5)] dark:shadow-[0_0_12px_rgba(248,113,113,0.5)]">
                {{ __('frontend.logout') }}
            </button>
        </form>
    </div>
</div>
