@php
    $locale = app()->getLocale();

    function convertToArabicNumbers($string)
    {
        $western = range(0, 9);
        $eastern = ['٠','١','٢','٣','٤','٥','٦','٧','٨','٩'];
        return str_replace($western, $eastern, $string);
    }

    $dateAr = convertToArabicNumbers(\Carbon\Carbon::now()->locale('ar')->translatedFormat('d F Y - h:i A'));
    $dateEn = \Carbon\Carbon::now()->locale('en')->translatedFormat('d F Y - h:i A');
    $website = env('APP_URL', 'https://orascom.com');
    $documentId = 'DOC-' . now()->format('Ymd-His') . '-' . Str::upper(Str::random(4));
@endphp

<!DOCTYPE html>
<html lang="{{ $locale }}" dir="{{ $locale === 'ar' ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="UTF-8">
    <title>{{ __('frontend.terms') }}</title>
    <style>
        @font-face {
            font-family: 'Cairo';
            src: url('/assets/fonts/Cairo-Bold.ttf') format('truetype');
            font-weight: normal;
            font-style: normal;
        }

        body {
            font-family: 'Cairo', sans-serif;
            direction: {{ $locale === 'ar' ? 'rtl' : 'ltr' }};
            background: #fff;
            margin: 0;
            padding: 0;
            color: #222;
        }

        .container {
            max-width: 850px;
            margin: auto;
            padding: 40px;
            background: #fdfdfd;
            border: 1px solid #ccc;
            border-radius: 12px;
        }

        /* 🧱 Header Flex Row */
        .top-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 30px;
            flex-wrap: wrap;
        }

        .header-left {
            flex: 1;
            text-align: {{ $locale === 'ar' ? 'right' : 'left' }};
            font-size: 14px;
            line-height: 1.5;
        }

        .header-right {
            flex: 1;
            text-align: center;
        }

        .header-right .date-text {
            font-size: 13px;
            margin-bottom: 8px;
            color: #444;
        }

        .logo img {
            height: 50px;
        }

        h1 {
            text-align: center;
            font-size: 24px;
            margin-top: 10px;
            color: #0f172a;
        }

        ol.terms {
            font-size: 16px;
            line-height: 1.9;
            padding: 0 1.5rem;
        }

        ol.terms li {
            margin-bottom: 1.3rem;
        }

        /* ✍️ Footer */
        footer.page-footer {
            display: flex;
            justify-content: space-between;
            align-items: flex-end;
            margin-top: 60px;
            font-size: 13px;
            color: #444;
            border-top: 1px solid #ccc;
            padding-top: 10px;
        }

        .signature {
            text-align: {{ $locale === 'ar' ? 'right' : 'left' }};
        }

        .signature p {
            margin: 3px 0;
            font-size: 14px;
        }

        .stamp {
            height: 60px;
            margin-top: 8px;
        }

        .print-actions {
            margin: 30px auto;
            text-align: center;
        }

        .print-btn {
            padding: 10px 20px;
            background-color: #2563eb;
            color: white;
            border: none;
            font-size: 16px;
            border-radius: 6px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
        }

        .pdf-btn {
            background-color: #059669;
            margin-inline-start: 12px;
        }

        @media print {
            .print-actions {
                display: none !important;
            }

            footer.page-footer {
                font-size: 11px;
                color: #888;
            }
        }
    </style>
</head>
<body>

<div class="container">

    <!-- 🧱 Header: Company Info - Logo - Date -->

    <header>
        <table width="100%" style="margin-bottom: 30px;">
            <tr>
                <td colspan="3" style="text-align: {{ $locale === 'ar' ? 'right' : 'left' }}; font-size: 13px; line-height: 1.5;">
                    <strong>{{ __('frontend.company_name') }}</strong><br>
                    {{ __('frontend.tittlewelcomepage') }}
                </td>
                <td colspan="3" style="text-align: {{ $locale === 'ar' ? 'left' : 'right' }};">
                    <img src="/assets/img/logo.png" alt="Logo" style="height: 30px;"><br>
                    <span style="font-size: 12px; display: block; margin-top: 5px;">
                        {{ $locale === 'ar' ? $dateAr : $dateEn }}
                    </span>
                </td>
            </tr>
        </table>
    </header>
    <hr><br>

    <!-- 📄 Title -->
    <h1>{{ __('frontend.terms') }}</h1>

    <!-- 📑 Terms -->
    <ol class="terms">
        <li>{!! __('frontend.term_item1') !!}</li>
        <li>{!! __('frontend.term_item2') !!}</li>
        <li>{!! __('frontend.term_item3') !!}</li>
        <li>{!! __('frontend.term_item4') !!}</li>
        <li>{!! __('frontend.term_item5') !!}</li>
    </ol>

    <!-- 🧾 Footer -->
    <footer class="page-footer">
        <div class="signature">
            <p>{{ __('frontend.hrmanager') }}</p>
            <p><strong>{{ __('backend.eng_name') }}</strong></p>
            <img src="/assets/img/stamp.png" alt="Company Stamp" class="stamp">
        </div>
        <div style="font-size: 13px; margin-top: 10px; color: #555; text-align: center;">
            {{ __('frontend.document_id') }} {{ $documentId }}
        </div>

        <div class="footer-right" style="text-align: {{ $locale === 'ar' ? 'left' : 'right' }}">
            <p>📄 {{ __('frontend.page') }} 1</p>
            <p>🌐 {{ $website }}</p>
        </div>
    </footer>
</div>

<!-- 🖨️ Buttons -->
<div class="print-actions">
    <button class="print-btn" onclick="window.print()">🖨️ {{ __('frontend.printpage') }}</button>
    <a href="{{ route('terms.download') }}" class="print-btn pdf-btn" target="_blank">📄 {{ __('frontend.download_pdf') }}</a>
</div>

</body>
</html>
