@php
    $locale = app()->getLocale();

    function convertToArabicNumbers($string)
    {
        $western = range(0, 9);
        $eastern = ['٠','١','٢','٣','٤','٥','٦','٧','٨','٩'];
        return str_replace($western, $eastern, $string);
    }

    $rawAr = \Carbon\Carbon::now()->locale('ar')->translatedFormat('d F Y - h:i A');
    $dateAr = convertToArabicNumbers($rawAr);
    $dateEn = \Carbon\Carbon::now()->locale('en')->translatedFormat('d F Y - h:i A');

    $website = env('APP_URL', 'https://orascom.com');
    $documentId = 'DOC-' . now()->format('Ymd-His') . '-' . Str::upper(Str::random(4));
@endphp

<!DOCTYPE html>
<html lang="{{ $locale }}" dir="{{ $locale === 'ar' ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="UTF-8">
    <title>{{ __('frontend.terms') }}</title>
    <style>
        @page {
            margin: 60px 40px;
        }

        body {
            font-family: 'amiri';
            direction: {{ $locale === 'ar' ? 'rtl' : 'ltr' }};
            text-align: {{ $locale === 'ar' ? 'right' : 'left' }};
            font-size: 14px;
            line-height: 1.8;
            color: #222;
            position: relative;
        }

        header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 30px;
        }

        .company-info {
            text-align: {{ $locale === 'ar' ? 'right' : 'left' }};
            font-size: 13px;
            line-height: 1.4;
        }

        .date-info {
            text-align: {{ $locale === 'ar' ? 'left' : 'right' }};
            font-size: 12px;
            line-height: 1.4;
        }

        header div {
    flex: 1;
}

.logo {
    display: flex;
    justify-content: center;
}

        .logo img {
            height: 80px;
        }

        h1.title {
            text-align: center;
            font-size: 22px;
            margin-bottom: 25px;
        }

        ol.terms {
            margin-top: 10px;
            padding-{{ $locale === 'ar' ? 'right' : 'left' }}: 20px;
        }

        footer {
            position: absolute;
            bottom: 40px;
            left: 40px;
            right: 40px;
            display: flex;
            justify-content: space-between;
            align-items: flex-end;
            font-size: 12px;
            color: #444;
        }

        .signature {
            text-align: {{ $locale === 'ar' ? 'right' : 'left' }};
        }

        .signature p {
            margin: 3px 0;
        }

        .page-footer {
            text-align: {{ $locale === 'ar' ? 'left' : 'right' }};
        }
    </style>
</head>
<body>
    <!-- Header -->
    <header>
    <table width="100%" style="margin-bottom: 30px;">
        <tr>
            <td colspan="3" style="text-align: {{ $locale === 'ar' ? 'right' : 'left' }}; font-size: 13px; line-height: 1.5;">
                <strong>{{ __('frontend.company_name') }}</strong><br>
                {{ __('frontend.tittlewelcomepage') }}
            </td>
            <td colspan="3" style="text-align: {{ $locale === 'ar' ? 'left' : 'right' }};">
                <img src="{{ public_path('assets/img/logo.png') }}" alt="Logo" style="height: 30px;"><br>
                <span style="font-size: 12px; display: block; margin-top: 5px;">
                    {{ $locale === 'ar' ? $dateAr : $dateEn }}
                </span>
            </td>
        </tr>
    </table>
</header>


    <!-- Title -->
    <h1 class="title">{{ __('frontend.terms') }}</h1>

    <!-- Terms -->
    <ol class="terms">
        <li>{!! __('frontend.term_item1') !!}</li>
        <li>{!! __('frontend.term_item2') !!}</li>
        <li>{!! __('frontend.term_item3') !!}</li>
        <li>{!! __('frontend.term_item4') !!}</li>
        <li>{!! __('frontend.term_item5') !!}</li>
    </ol>

    <!-- Footer -->
    <footer>
        <table width="100%" style="position: absolute; bottom: 40px; left: 40px; right: 40px; font-size: 12px; color: #444;">
            <tr>
                <!-- توقيع HR -->
                <td style="text-align: {{ $locale === 'ar' ? 'right' : 'left' }}; width: 33%;">
                    <p style="margin: 2px 0;">{{ __('frontend.hrmanager') }}</p>
                    <p style="margin: 2px 0;"><strong>{{ __('backend.eng_name') }}</strong></p>
                </td>

                <!-- رقم المستند في النص -->
                <td style="text-align: center; width: 34%;">
                    <div style="font-size: 13px; margin-top: 10px; color: #555;">
                        {{ __('frontend.document_id') }} {{ $documentId }}
                    </div>
                </td>

                <!-- رقم الصفحة والموقع -->
                <td style="text-align: {{ $locale === 'ar' ? 'left' : 'right' }}; width: 33%;">
                    <p style="margin: 2px 0;">📄 {{ __('frontend.page') }} 1/1</p>
                    <p style="margin: 2px 0;">🌐 {{ $website }}</p>
                </td>
            </tr>
        </table>
    </footer>

</body>
</html>
