{{-- مثال على كيفية استخدام Advanced Loader في صفحات مختلفة --}}
<div>
    {{-- 1. في صفحة تسجيل الدخول --}}
    <form wire:submit.prevent="login">
        {{-- Loading للنموذج --}}
        <x-ui.advanced-loader type="form" size="md" wire:loading.delay.longer wire:target="login" />

        {{-- باقي النموذج --}}
        <input type="email" wire:model="email" />
        <input type="password" wire:model="password" />

        <button type="submit">تسجيل الدخول</button>
    </form>

    {{-- 2. في صفحة رفع الملفات --}}
    <div>
        {{-- Loading لرفع الملفات --}}
        <x-ui.advanced-loader type="upload" size="lg" :progress="$uploadProgress" wire:loading.delay
            wire:target="uploadFiles" />

        <input type="file" wire:model="files" multiple />
        <button wire:click="uploadFiles">رفع الملفات</button>
    </div>

    {{-- 3. في صفحة معالجة البيانات --}}
    <div>
        {{-- Loading لمعالجة البيانات --}}
        <x-ui.advanced-loader type="processing" message="جاري تحليل البيانات..." wire:loading.delay
            wire:target="processData" />

        <button wire:click="processData">معالجة البيانات</button>
    </div>

    {{-- 4. استخدام مع JavaScript --}}
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // عند الضغط على زر
            document.getElementById('ajax-btn').addEventListener('click', async function() {
                // عرض loader
                showLoader('ajax-request', {
                    type: 'form',
                    message: 'جاري إرسال الطلب...'
                });

                try {
                    const response = await fetch('/api/data');
                    const data = await response.json();

                    // إخفاء loader
                    hideLoader('ajax-request');

                    // معالجة البيانات
                    console.log(data);
                } catch (error) {
                    hideLoader('ajax-request');
                    console.error(error);
                }
            });

            // مثال على رفع ملف مع progress
            document.getElementById('file-input').addEventListener('change', function(e) {
                const file = e.target.files[0];
                if (!file) return;

                const formData = new FormData();
                formData.append('file', file);

                // عرض loader مع progress
                showLoader('file-upload', {
                    type: 'upload',
                    progress: 0,
                    message: 'جاري رفع الملف...'
                });

                // XMLHttpRequest للحصول على progress
                const xhr = new XMLHttpRequest();

                xhr.upload.addEventListener('progress', function(e) {
                    if (e.lengthComputable) {
                        const percentComplete = (e.loaded / e.total) * 100;
                        updateLoaderProgress('file-upload', percentComplete,
                            `تم رفع ${Math.round(percentComplete)}%`);
                    }
                });

                xhr.addEventListener('load', function() {
                    hideLoader('file-upload');
                    alert('تم رفع الملف بنجاح!');
                });

                xhr.addEventListener('error', function() {
                    hideLoader('file-upload');
                    alert('حدث خطأ أثناء رفع الملف');
                });

                xhr.open('POST', '/upload');
                xhr.send(formData);
            });
        });
    </script>

    {{-- 5. مثال متقدم مع عدة مراحل --}}
    <div x-data="multiStepProcess()">
        <button @click="startProcess">بدء العملية متعددة المراحل</button>

        <script>
            function multiStepProcess() {
                return {
                    async startProcess() {
                        try {
                            // المرحلة 1: التحقق
                            showLoader('step1', {
                                type: 'processing',
                                message: 'المرحلة 1: جاري التحقق من البيانات...'
                            });
                            await this.validateData();
                            hideLoader('step1');

                            // المرحلة 2: الرفع
                            showLoader('step2', {
                                type: 'upload',
                                message: 'المرحلة 2: جاري رفع الملفات...'
                            });
                            await this.uploadFiles();
                            hideLoader('step2');

                            // المرحلة 3: الحفظ
                            showLoader('step3', {
                                type: 'form',
                                message: 'المرحلة 3: جاري حفظ البيانات...'
                            });
                            await this.saveData();
                            hideLoader('step3');

                            alert('تمت العملية بنجاح!');
                        } catch (error) {
                            // إخفاء جميع الـ loaders في حالة الخطأ
                            ['step1', 'step2', 'step3'].forEach(id => hideLoader(id));
                            alert('حدث خطأ: ' + error.message);
                        }
                    },

                    validateData() {
                        return new Promise(resolve => setTimeout(resolve, 2000));
                    },

                    uploadFiles() {
                        return new Promise(resolve => setTimeout(resolve, 3000));
                    },

                    saveData() {
                        return new Promise(resolve => setTimeout(resolve, 1500));
                    }
                }
            }
        </script>
    </div>

    {{-- 6. استخدام مع Livewire Events --}}
    <div>
        <button wire:click="$dispatch('start-long-process')">بدء عملية طويلة</button>

        <script>
            document.addEventListener('livewire:init', () => {
                Livewire.on('start-long-process', () => {
                    showLoader('long-process', {
                        type: 'processing',
                        size: 'lg',
                        message: 'جاري المعالجة... قد يستغرق هذا دقائق قليلة'
                    });
                });

                Livewire.on('long-process-complete', () => {
                    hideLoader('long-process');
                });

                Livewire.on('update-process-progress', (event) => {
                    updateLoaderProgress('long-process', event.progress, event.message);
                });
            });
        </script>
    </div>
</div>
