<x-backend.layouts.struct :title="__('backend.department_name') . ' | ' . __('backend.dashboard')">



     {{-- ——— إحصائيات سريعة ——— --}}
     <div class="max-w-7xl mx-auto mt-8 grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-4">

        {{-- مشاريع --}}
        @access('dashboard','projects_count')
            @php($projectsCount = \App\Models\User\UserProject::count())
            <div
                x-data="{ count: 0 }"
                x-init="
                  let target = {{ $projectsCount }};
                  let step   = Math.ceil(target / 30);
                  let i = 0;
                  const timer = setInterval(() => {
                    i += step;
                    if(i >= target){ i = target; clearInterval(timer); }
                    count = i;
                  }, 20);
                "
                class="bg-white dark:bg-zinc-900 border p-4 rounded-xl shadow flex flex-col justify-between"
            >
                <div class="flex items-center">
                    <svg xmlns="http://www.w3.org/2000/svg"
                         class="w-8 h-8 text-green-500 opacity-75"
                         fill="none" viewBox="0 0 24 24" stroke="currentColor">
                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M3 7h18M3 12h18M3 17h18"/>
                    </svg>
                    <div class="ml-3">
                        <div class="text-3xl font-bold text-gray-900 dark:text-gray-100" x-text="count"></div>
                        <div class="text-sm text-gray-500 dark:text-gray-400">{{ __('backend.projects') }}</div>
                    </div>
                </div>
                <a href="{{ route('project.index') }}"
                   class="mt-3 text-sm font-medium text-green-600 hover:underline">
                    {{ __('backend.view_all') }}
                </a>
            </div>
        @endaccess

        {{-- مستخدمين --}}
        @access('dashboard','user_count')
            @php($usersCount = \App\Models\User::count())
            <div
                x-data="{ count: 0 }"
                x-init="
                  let t2 = {{ $usersCount }};
                  let s2 = Math.ceil(t2 / 30);
                  let j = 0;
                  const tm2 = setInterval(() => {
                    j += s2;
                    if(j >= t2){ j = t2; clearInterval(tm2); }
                    count = j;
                  }, 20);
                "
                class="bg-white dark:bg-zinc-900 border p-4 rounded-xl shadow flex flex-col justify-between"
            >
                <div class="flex items-center">
                    <svg xmlns="http://www.w3.org/2000/svg"
                         class="w-8 h-8 text-blue-500 opacity-75"
                         fill="none" viewBox="0 0 24 24" stroke="currentColor">
                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M17 20h5v-2a3 3 0 00-5.356-1.857M9 20h6M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                    </svg>
                    <div class="ml-3">
                        <div class="text-3xl font-bold text-gray-900 dark:text-gray-100" x-text="count"></div>
                        <div class="text-sm text-gray-500 dark:text-gray-400">{{ __('backend.users_count') }}</div>
                    </div>
                </div>
                <a href="{{ route('users.index') }}"
                   class="mt-3 text-sm font-medium text-blue-600 hover:underline">
                    {{ __('backend.view_all') }}
                </a>
            </div>
        @endaccess

        {{-- موظفين --}}
        @access('dashboard','employee_count')
            @php($employeesCount = \App\Models\User\UserEmployee::count())
            <div
                x-data="{ count: 0 }"
                x-init="
                  let t3 = {{ $employeesCount }};
                  let s3 = Math.ceil(t3 / 30);
                  let k = 0;
                  const tm3 = setInterval(() => {
                    k += s3;
                    if(k >= t3){ k = t3; clearInterval(tm3); }
                    count = k;
                  }, 20);
                "
                class="bg-white dark:bg-zinc-900 border p-4 rounded-xl shadow flex flex-col justify-between"
            >
                <div class="flex items-center">
                    <svg xmlns="http://www.w3.org/2000/svg"
                         class="w-8 h-8 text-purple-500 opacity-75"
                         fill="none" viewBox="0 0 24 24" stroke="currentColor">
                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M5.121 17.804A13.937 13.937 0 0112 15c3.042 0 5.824.966 7.879 2.804M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                    </svg>
                    <div class="ml-3">
                        <div class="text-3xl font-bold text-gray-900 dark:text-gray-100" x-text="count"></div>
                        <div class="text-sm text-gray-500 dark:text-gray-400">{{ __('backend.employees_count') }}</div>
                    </div>
                </div>
                <a href="{{ route('emp.index') }}"
                   class="mt-3 text-sm font-medium text-purple-600 hover:underline">
                    {{ __('backend.view_all') }}
                </a>
            </div>
        @endaccess




            @foreach(\App\Models\User\UserJobTitle::withCount('employees')->get() as $jobTitle)
                @access('dashboard', 'job_title_' . $jobTitle->id)
                    <div
                        x-data="{ count: 0 }"
                        x-init="
                          let target = {{ $jobTitle->employees_count }};
                          let step   = Math.ceil(target / 30);
                          let i = 0;
                          const timer = setInterval(() => {
                            i += step;
                            if(i >= target){ i = target; clearInterval(timer); }
                            count = i;
                          }, 20);
                        "
                        class="bg-white dark:bg-zinc-900 border p-4 rounded-xl shadow flex flex-col justify-between"
                    >
                        <div class="flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg"
                                 class="w-8 h-8 text-yellow-500 opacity-75"
                                 fill="none" viewBox="0 0 24 24" stroke="currentColor">
                              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M9 12h6m-3-3v6"/>
                            </svg>
                            <div class="ml-3">
                                <div class="text-3xl font-bold text-gray-900 dark:text-gray-100" x-text="count"></div>
                                <div class="text-sm text-gray-500 dark:text-gray-400">
                                    {{ app()->getLocale() === 'ar'
                                        ? $jobTitle->title_ar
                                        : $jobTitle->title_en }}
                                </div>
                            </div>
                        </div>
                        <a href="{{ route('emp.index', ['job_title_id' => $jobTitle->id]) }}"
                           class="mt-3 text-sm font-medium text-yellow-600 hover:underline">
                            {{ __('backend.view_all') }}
                        </a>
                    </div>
                @endaccess
            @endforeach
        </div>



    {{-- بطاقة الترحيب --}}
    <div class="max-w-4xl mx-auto mt-10">
        <div
            class="rounded-3xl shadow-xl p-8 relative overflow-hidden
                   bg-gradient-to-r from-indigo-500 via-purple-500 to-pink-500
                   dark:from-zinc-800 dark:via-zinc-700 dark:to-zinc-900
                   text-black dark:text-gray-100 transition-colors duration-500 animate-fade-in"
            style="min-height: 320px;"
        >
            <img src="/assets/img/logo.png"
                 alt="Survey Decoration"
                 class="absolute bottom-4 start-4 w-32 h-32 object-contain opacity-30 pointer-events-none" />
            <div class="absolute -top-10 -left-10 w-40 h-40 bg-white/10 dark:bg-white/5 rounded-full blur-3xl"></div>
            <div class="absolute -bottom-10 -right-10 w-40 h-40 bg-white/10 dark:bg-white/5 rounded-full blur-3xl"></div>

            <div class="relative z-10 text-center">
                <div class="text-6xl mb-4">📡</div>
                <h1 class="text-5xl font-bold mb-2">{{ __('backend.department_name') }}</h1>
                <h3 class="text-4xl font-bold mb-2">{{ __('backend.eng_name') }}</h3>
                <h3 class="text-3xl opacity-90 mb-4">{{ __('backend.type_welcome_message') }}</h3>
                <div class="mt-6">
                    <a href="#"
                       class="inline-flex items-center gap-2 px-6 py-2 rounded-full font-bold shadow-lg transition-all duration-300
                              text-white bg-gradient-to-r from-pink-500 via-purple-600 to-indigo-600
                              hover:scale-105 focus:outline-none focus:ring-4 focus:ring-pink-300">
                        {{ __('backend.guide') }}
                        <svg xmlns="http://www.w3.org/2000/svg"
                             class="w-5 h-5 transition-transform duration-300 group-hover:translate-x-1"
                             fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                  d="M14 5l7 7m0 0l-7 7m7-7H3"/>
                        </svg>
                    </a>
                </div>
            </div>
        </div>
    </div>





</x-backend.layouts.struct>
