<!DOCTYPE html>
@php
    $settings = Auth::user()?->settings ?? [];
    $dark = array_key_exists('dark_mode', $settings)
        ? json_encode($settings['dark_mode'])
        : 'localStorage.getItem("theme") === "dark"';

    $lang = array_key_exists('language', $settings) ? "'{$settings['language']}'" : "'" . app()->getLocale() . "'";

@endphp
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" x-data="{
    darkMode: {{ $dark }},

    toggleTheme() {
        this.darkMode = !this.darkMode;
        localStorage.setItem('theme', this.darkMode ? 'dark' : 'light');
        @if (Auth::check()) fetch('{{ route('update.darkmode', ['id' => Auth::id()]) }}'); @endif
    },
    locale: {{ $lang }},
    switchLang() {
        const target = this.locale === 'ar' ? 'en' : 'ar';
        this.locale = target;
        document.documentElement.setAttribute('dir', target === 'ar' ? 'rtl' : 'ltr');
        window.location.href = '{{ url('set-language') }}/' + target;
    }
}" x-init="$watch('darkMode', val => localStorage.setItem('theme', val ? 'dark' : 'light'));
document.documentElement.setAttribute('dir', locale === 'ar' ? 'rtl' : 'ltr');"
    x-bind:class="{ 'dark': darkMode }" class="transition duration-500">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />

    <title>{{ $title ?? 'Orascom' }}</title>

    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600" rel="stylesheet" />

    @vite(['resources/css/frontend/app.css', 'resources/js/app.js'])
    @fluxAppearance

    @if (Auth::check())
        <script>
            localStorage.setItem('theme', {{ $dark }});
            // localStorage.setItem('lang', {{ $lang !== 'null' ? $lang : '"' . app()->getLocale() . '"' }});
            localStorage.setItem('lang', "{{ $lang !== 'null' ? $lang : app()->getLocale() }}");
        </script>
    @endif
</head>

