// Advanced Loader Debug Helper
// إضافة هذا الكود إلى console للمساعدة في debugging

window.debugAdvancedLoader = function() {
    console.group('🔍 Advanced Loader Debug Info');

    // معلومات عن الـ instances
    console.log('Active Instances:', window.AdvancedLoader.instances.size);
    window.AdvancedLoader.instances.forEach((instance, id) => {
        console.log(`- ${id}:`, {
            visible: instance.isVisible,
            startTime: new Date(instance.startTime).toLocaleTimeString(),
            age: Math.round((Date.now() - instance.startTime) / 1000) + 's',
            type: instance.config.type,
            retryCount: instance.retryCount
        });
    });

    // معلومات عن الشبكة
    console.log('Network Speed:', window.AdvancedLoader.networkSpeed);

    // معلومات عن Livewire
    if (window.Livewire) {
        console.log('Livewire Status:', 'Available');
        console.log('Livewire Version:', window.Livewire?.version || 'Unknown');
    } else {
        console.warn('Livewire:', 'Not Available');
    }

    console.groupEnd();
};

// إضافة shortcut
window.dlg = window.debugAdvancedLoader;

console.log('🚀 Advanced Loader Debug Helper loaded. Use debugAdvancedLoader() or dlg() for debug info.');
