﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Threading.Tasks;
using System.Windows;

namespace SilkroadLauncher
{
    public class DatabaseService
    {
        private string _connectionString;

        public async Task<bool> InitializeConnectionAsync()
        {
            var config = await Config.LoadDatabaseConfigAsync();

            if (config == null || !config.ContainsKey("Server") || !config.ContainsKey("Database"))
            {
                MessageBox.Show("❌ Invalid configuration data.", "Connection Error", MessageBoxButton.OK, MessageBoxImage.Error);
                return false;
            }

            try
            {
                _connectionString =
                    $"Data Source={config["Server"]};" +
                    $"Initial Catalog={config["Database"]};" +
                    $"User ID={config["User"]};" +
                    $"Password={config["Password"]};";

                // اختبار الاتصال
                using (SqlConnection conn = new SqlConnection(_connectionString))
                {
                    await conn.OpenAsync();
                    conn.Close();
                }

                return true;
            }
            catch (Exception)
            {
                MessageBox.Show("❌ Failed to connect to the database.", "Connection Error", MessageBoxButton.OK, MessageBoxImage.Error);
                return false;
            }
        }

        // تقدر تضيف دوال لاحقًا تستخدم _connectionString مباشرة لاستعلامات أخرى
    }
}
