﻿using System;
using System.Collections.Generic;
using System.Net.Http;
using System.Threading.Tasks;
using System.Windows;

namespace SilkroadLauncher
{
    public static class Config
    {
        private const string ConfigUrl = "https://victory.4tressro.com/Launcher/config.ini";

        public static async Task<Dictionary<string, string>> LoadDatabaseConfigAsync()
        {
            using (var client = new HttpClient())
            {
                try
                {
                    string content = await client.GetStringAsync(ConfigUrl);
                    return ParseIni(content);
                }
                catch (Exception)
                {
                    MessageBox.Show("❌ Check your internet connection.", "Connection Error", MessageBoxButton.OK, MessageBoxImage.Error);
                    return null;
                }
            }
        }


        private static Dictionary<string, string> ParseIni(string content)
        {
            var result = new Dictionary<string, string>();
            var lines = content.Split('\n');
            bool insideDbSection = false;

            foreach (var raw in lines)
            {
                var line = raw.Trim();

                if (line.StartsWith(";") || string.IsNullOrWhiteSpace(line))
                    continue;

                if (line.StartsWith("[") && line.EndsWith("]"))
                {
                    insideDbSection = line.Equals("[Database]", StringComparison.OrdinalIgnoreCase);
                    continue;
                }

                if (insideDbSection)
                {
                    var parts = line.Split('=');
                    if (parts.Length == 2)
                        result[parts[0].Trim()] = parts[1].Trim();
                }
            }
            if (result.Count == 0)
                return new Dictionary<string, string>(); // ملف موجود لكن مفيهوش Config

            return result;
        }
    }
}
