<?php

namespace App\Traits;

use App\Models\System\SystemOperationLog;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Request;

trait LogsActivity
{
    public function logActivity(
        string $operation,
        ?string $details = null,
        ?string $table = null,
        ?int $recordId = null,
        ?int $userId = null
    ): void {
        // محاولة ذكية للحصول على الـ user_id
        $resolvedUserId = $userId
            ?? Auth::id()
            ?? $this->resolveUserIdFromEmail();

            SystemOperationLog::create([
            'user_id'     => $resolvedUserId,
            'operation'   => $operation,
            'details'     => $details ?? $this->generateDefaultMessage($operation),
            'table_name'  => $table,
            'record_id'   => $recordId,
            'controller'  => class_basename(static::class),
            'ip_address'  => Request::ip(),
            'user_agent'  => Request::header('User-Agent'),
        ]);
    }

    /**
     * توليد رسالة افتراضية حسب نوع العملية
     */
    protected function generateDefaultMessage(string $operation): string
    {
        return match (strtolower($operation)) {
            'login'     => 'User logged in.',
            'logout'    => 'User logged out.',
            'create'    => 'Record created.',
            'update'    => 'Record updated.',
            'delete'    => 'Record deleted.',
            default     => 'Operation: ' . ucfirst($operation),
        };
    }

    /**
     * محاولة استخراج user_id من البريد الإلكتروني (لو موجود في الكلاس)
     */
    protected function resolveUserIdFromEmail(): ?int
    {
        if (property_exists($this, 'email') && !empty($this->email)) {
            return User::where('email', $this->email)->value('id');
        }

        return null;
    }
}
