<?php

namespace App\Traits;
use App\Models\System\SystemRoute;

trait HasPageAccess
{
    public function hasAccessToRoute(SystemRoute|string $route): bool
    {
         // 🟡 لو مررنا فقط اسم route كـ string
         if (is_string($route)) {
            $route = SystemRoute::where('name', $route)->first();
            if (!$route) return false;
        }

        // 🟢 السماح التلقائي إذا كانت system route
        if ($route->main_group === 'system') {
            return true;
        }

        // 🟢 نقرأ الصلاحيات من جدول المستخدم
        $pages = $this->pages;

        if (is_string($pages)) {
            $pages = json_decode($pages, true);
        }

        if (!is_array($pages) || !isset($pages['page'])) {
            return false;
        }

        $userPages = $pages['page'];

        if (!is_array($userPages)) {
            $userPages = [$userPages];
        }

        // ✅ صلاحية كاملة
        if (in_array('[all]', $userPages)) {
            return true;
        }

        // ✅ صلاحية محددة
        return in_array($route->name, $userPages);
    }
}
