<?php

namespace App\Models\User;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class UserProject extends Model
{
    protected $table = 'users_projects';

    protected $fillable = [
        'code',
        'name',
        'manager_id',
        'description',
    ];



    /**
     * علاقة المشروع بالموظفين.
     */
    public function employees(): HasMany
    {
        return $this->hasMany(UserEmployee::class, 'project_code', 'code');
    }

    /**
     * علاقة المشروع بمدير المشروع.
     */
    public function manager(): BelongsTo
    {
        return $this->belongsTo(UserEmployee::class, 'manager_id');
    }

    /**
     * علاقة المشروع بالمستخدمين.
     */
    public function users(): HasMany
    {
        return $this->hasMany(User::class, 'project_code', 'code');
    }


    public function cvCodes(): HasMany
    {
        return $this->hasMany(
            \App\Models\Emp\UserEmployeeCvCode::class,
            'project_code', // العمود فى جدول الأكواد
            'code'          // العمود فى جدول المشاريع
        );
    }
}
