<?php

namespace App\Models\User;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class UserJobTitle extends Model
{
    protected $table = 'users_job_titles';

    protected $fillable = [
        'title_en',
        'title_ar',
        'description',
    ];

    public function employees(): HasMany
    {
        return $this->hasMany(UserEmployee::class, 'job_title_id');
    }


}
