<?php

namespace App\Models\User;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


class UserEmployeeReview extends Model
{
    use HasFactory;

    protected $table = 'users_employees_review'; // اسم الجدول

    protected $fillable = [
        'project_code',
        'employee_code',
        'department_id',
        'full_name',
        'job_title_id',
        'national_id',
        'birth_date',
        'governorate',
        'gender',
        'id_card_image',
        'documents',
        'status',
        'differences',
    ];

    protected $casts = [
        'full_name' => 'array',
        'governorate' => 'array',
        'documents' => 'array',
        'differences' => 'array',
        'birth_date' => 'date',
    ];

}
