<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;

use App\Models\User\UserEmployee;
use App\Models\User\UserProject;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Str;
use App\Traits\HasPageAccess;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
/**
 * @method bool hasAccessToRoute(string $routeName)
 * @property-read array|null $pages
 */

class User extends Authenticatable
{

    use HasPageAccess;
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [

        'name',
        'email',
        'password',
        'settings',
        'user_state',
        'phone',
        'pages',
        'activation_token',
        'employee_id',
        'project_code',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'settings' => 'array',
            'pages' => 'array',
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }

    /**
     * Get the user's initials
     */
    public function initials(): string
    {
        return Str::of($this->name)
            ->explode(' ')
            ->map(fn(string $name) => Str::of($name)->substr(0, 1))
            ->implode('');
    }

    public function isDarkModeEnabled(): bool
    {
        return $this->settings['dark_mode'] ?? false;
    }

    public function toggleDarkMode(): void
    {
        $settings = $this->settings ?? [];

        $settings['dark_mode'] = !($settings['dark_mode'] ?? false);

        $this->settings = $settings;
        $this->save();
    }

    public function project(): BelongsTo
    {
        return $this->belongsTo(UserProject::class, 'project_code', 'code');
    }

public function employee(): BelongsTo
{
    return $this->belongsTo(UserEmployee::class, 'employee_id');
}

}
