<?php

namespace App\Models\TimeKeeper;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Shift extends Model
{
    protected $table = 'employees_tk_shifts';

    protected $fillable = [
        'name',
        'start_time',
        'end_time',
        'is_night_shift',
        'description',
    ];

    protected $casts = [
        'is_night_shift' => 'boolean',
        'start_time' => 'datetime:H:i',
        'end_time' => 'datetime:H:i',
    ];

    public function assignments(): HasMany
    {
        return $this->hasMany(ShiftAssignment::class, 'shift_id');
    }
}
