<?php

namespace App\Models\TimeKeeper;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\User;
use App\Models\UserEmployee;

class AttendanceLog extends Model
{
    protected $table = 'employees_tk_attendance_log';

    protected $fillable = [
        'employee_id',
        'attendance_date',
        'date_parts',
        'check_in',
        'check_out',
        'status',
        'approved_by',
        'final_hr_approval_by',
        'notes',
    ];

    protected $casts = [
        'attendance_date' => 'date',
        'date_parts' => 'array',
        'check_in' => 'datetime:H:i',
        'check_out' => 'datetime:H:i',
    ];

    public function employee(): BelongsTo
    {
        return $this->belongsTo(UserEmployee::class, 'employee_id');
    }

    public function approvedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'approved_by');
    }

    public function finalHR(): BelongsTo
    {
        return $this->belongsTo(User::class, 'final_hr_approval_by');
    }
}
