<?php

namespace App\Models\System;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class SystemOperationLog extends Model
{
    protected $table = 'system_operation_logs';

    protected $fillable = [
        'user_id',
        'operation',
        'details',
        'table_name',
        'record_id',
        'controller',
        'ip_address',
        'user_agent',
    ];

    /**
     * علاقة السجل بالمستخدم.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
