<?php
// need some work
namespace App\Http\Middleware;

use App\Models\System\SystemRoute;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckUserPermission
{
    /**
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure                  $next
     * @param  string                    $page      اسم الصفحة (مفتاح من pages.page)
     * @param  string|null               $element   اسم العنصر (مفتاح من pages.element[page])
     */
    public function handle(Request $request, Closure $next, string $page = null, string $element = null): Response
    {

        // اسم الرُوت الحالي
        $routeName = $request->route()?->getName();

        // قائمة الرُوتات الثابتة التي لا تحتاج تحقق من settings.pages

        $staticRoutes = SystemRoute::where('is_active', true)
        ->whereNotNull('order')
        ->orderBy('order')
        ->pluck('name')
        ->toArray();

        $staticRoutes = array_merge(['dashboard'], $staticRoutes);


        // إذا كان هذا الرُوت من الثابتات، نتجاوزه فوراً
        if (in_array($routeName, $staticRoutes, true)) {
            return $next($request);
        }

        $user = $request->user();
        if (! $user) {
            abort(403, 'Unauthorized');
        }





        // نستخدم اسم الصفحة الممرّر أو اسم الرُوت
        $page = $page ?? $routeName;
        // جلب المصفوفات من الحقل pages
        $pages    = $user->pages['page']    ?? [];
        $elements = $user->pages['element'] ?? [];

        // شرط صفحة [all] أو تواجد الصفحة المحددة


        if (! (in_array('[all]', $pages, true) || in_array($page, $pages, true))) {
            abort(403, "No access to page: {$page}");
        }


        // إذا أُرسل element، نتحقق منه أيضاً
        if ($element) {
            $pageElements = $elements[$page] ?? [];
            $hasElement   = in_array('[all]', $pages, true)
                || in_array($element, $pageElements, true);
            if (! $hasElement) {
                abort(403, "No access to element: {$element} in page: {$page}");
            }
        }

        return $next($request);
    }
}
