
<body class="min-h-screen bg-white antialiased dark:bg-linear-to-b dark:from-neutral-950 dark:to-neutral-900">


    <?php if(session('toast')): ?>
    <div x-data="{ show: true }" x-show="show" x-init="setTimeout(() => show = false, <?php echo e(session('toast.duration')); ?>)"
        class="fixed top-5 right-5 bg-green-500 text-white p-3 rounded shadow">
        <?php echo e(session('toast.msg')); ?>

    </div>
<?php endif; ?>


    <!-- Background -->
    <div class="fixed inset-0 z-[-1] overflow-hidden">
        <div
            class="absolute inset-0 bg-gradient-to-br from-[#f1f5f9] via-[#e0e7ff] to-[#fef9c3] dark:from-[#0f172a] dark:via-[#1e293b] dark:to-[#0a0a0a] transition-all duration-[3000ms]">
        </div>
        <div
            class="absolute top-[10%] left-[20%] w-[280px] h-[280px] bg-indigo-400 opacity-10 dark:opacity-20 rounded-full blur-[100px] animate-glow1">
        </div>
        <div
            class="absolute bottom-[10%] right-[20%] w-[300px] h-[300px] bg-pink-300 opacity-10 dark:opacity-20 rounded-full blur-[120px] animate-glow2">
        </div>
        <div
            class="absolute top-[50%] left-[50%] -translate-x-1/2 -translate-y-1/2 w-[200px] h-[200px] bg-blue-500 opacity-5 dark:opacity-15 rounded-full blur-[90px] animate-glow3">
        </div>
    </div>

    <!-- ⛑️ Preload -->
    <div class="hidden">
        translate-x-0 translate-x-7 opacity-40 opacity-100
        hover:scale-110 hover:rotate-12
    </div>


    <!-- ░░░ أزرار الثيم + اللغة ░░░ -->
    <div x-ref="buttonsContainer" class="absolute top-5 z-50 flex flex-row gap-3 transition-all duration-500"
        :class="locale === 'ar' ? 'left-5' : 'right-5'">

        <!-- زر الثيم -->
        <button @click="toggleTheme()"
            class="w-10 h-10 flex items-center justify-center rounded-full shadow-md transition-all duration-300
                 bg-zinc-800 text-white dark:bg-white dark:text-black hover:scale-110 hover:rotate-12">
            <template x-if="!darkMode">
                <svg class="w-7 h-7 text-yellow-400" viewBox="0 0 24 24" fill="currentColor">
                    <circle cx="12" cy="12" r="5" />
                    <path
                        d="M12 1v2M12 21v2M4.22 4.22l1.42 1.42M18.36 18.36l1.42 1.42M1 12h2M21 12h2M4.22 19.78l1.42-1.42M18.36 5.64l1.42-1.42" />
                </svg>
            </template>
            <template x-if="darkMode">
                <svg class="w-7 h-7 text-indigo-300" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M21 12.79A9 9 0 1111.21 3 7 7 0 0021 12.79z" />
                </svg>
            </template>
        </button>

        <!-- زر اللغة -->

        <button
            @click="
    const target = locale === 'ar' ? 'en' : 'ar';

    const animationClass = locale === 'ar' ? 'slide-right' : 'slide-left';

    $refs.buttonsContainer.classList.add('transition-slide', animationClass);

    setTimeout(() => {
        window.location.href = '<?php echo e(url('set-language')); ?>/' + target;
    }, 500);
"
            class="relative w-14 h-10 rounded-full shadow-md bg-white/90 dark:bg-zinc-800/90
       backdrop-blur flex items-center justify-center overflow-hidden
       transition-all duration-300 border border-zinc-300 dark:border-zinc-700">


            <!-- العقدة -->
            <div class="absolute top-0 left-0 h-10 w-7 bg-blue-600 dark:bg-indigo-500
            rounded-full transition-transform duration-300"
                :class="locale === 'ar' ? 'translate-x-7' : 'translate-x-0'"></div>

            <!-- 🇬🇧 UK SVG -->
            <svg class="absolute left-1 top-1 h-6 w-6 transition-opacity duration-300 select-none"
                :class="locale === 'en' ? 'opacity-100' : 'opacity-40'" viewBox="0 0 640 480">
                <path fill="#012169" d="M0 0h640v480H0z" />
                <path fill="#FFF"
                    d="M75 0l195 145L465 0h87v62L375 240l177 178v62h-87L320 301 125 480H38v-62l177-178L38 62V0h37z" />
                <path fill="#C8102E"
                    d="M212 0l108 81L428 0h48v31L341 240l135 209v31h-48L320 399 108 480H60v-31l135-209L60 31V0h48z" />
                <path fill="#FFF" d="M0 160h640v160H0z" />
                <path fill="#FFF" d="M240 0v480h160V0z" />
                <path fill="#C8102E" d="M0 192h640v96H0z" />
                <path fill="#C8102E" d="M272 0v480h96V0z" />
            </svg>

            <!-- 🇪🇬 Egypt SVG -->
            <svg class="absolute right-1 top-1 h-6 w-6 transition-opacity duration-300 select-none"
                :class="locale === 'ar' ? 'opacity-100' : 'opacity-40'" viewBox="0 0 640 480">
                <path fill="#CE1126" d="M0 0h640v160H0z" />
                <path fill="#FFF" d="M0 160h640v160H0z" />
                <path fill="#000" d="M0 320h640v160H0z" />
                <path fill="#CFB52B" d="M320 240l-30 50h60z" />
            </svg>
        </button>




    </div>




    <div class="bg-background flex min-h-svh flex-col items-center justify-center gap-6 p-6 md:p-10">
        <div class="flex w-full max-w-<?php echo e($maxWidth ?? 'sm'); ?> flex-col gap-2">
            <a href="<?php echo e(route('home')); ?>" class="flex flex-col items-center gap-2 font-medium" wire:navigate>
                
                <span class="sr-only"><?php echo e(config('app.name', 'Laravel')); ?></span>
            </a>
            <div class="flex flex-col gap-6">
                <?php echo e($slot); ?>

            </div>
        </div>
    </div>
    

</body>

</html>
<?php /**PATH C:\laragon\www\Survey_Department\resources\views/components/frontend/layouts/struct/body.blade.php ENDPATH**/ ?>