<?php

use Livewire\Volt\Component;
use Livewire\Attributes\On;

?>

<div>
    
    <div class="fixed top-1/2 left-1/2 z-[9999] -translate-x-1/2 -translate-y-1/2">
        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $toasts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $toast): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <!--[if BLOCK]><![endif]--><?php if($toast['type'] === 'rate-limit'): ?>
                <div
                    x-data="{
                        show:true,
                        remaining: <?php echo e($toast['countdown']); ?>,
                        progress:100
                    }"
                    x-init="
                        const total = remaining;
                        const t = setInterval(() => {
                            remaining--;
                            progress = (remaining/total)*100;
                            if (remaining<=0) {
                                clearInterval(t);
                                show = false;
                                Livewire.dispatch('rate-finished');
                            }
                        },1000);
                    "
                    x-show="show"
                    x-transition.opacity.duration.300ms
                    class="w-[360px] bg-red-800/95 text-white p-6 rounded-3xl shadow-2xl text-center space-y-5 animate-fade-in"
                >
                    
                    <div class="w-12 h-12 border-2 border-white rounded-full flex items-center justify-center bg-red-500/50 shadow-inner animate-pulse mx-auto">
                        
                        <div class="text-4xl animate-spin transition duration-[10000ms]">⏳</div>
                    </div>

                    
                    <div class="flex items-center justify-center gap-3">
                        <div class="text-5xl font-extrabold tracking-widest drop-shadow" x-text="remaining">0</div>
                    </div>

                    
                    <div class="text-sm font-medium text-white/90">
                        <?php echo e(__('auth.throttle')); ?>

                    </div>

                    
                    <div class="relative w-full h-2 bg-white/20 rounded overflow-hidden">
                        <div class="absolute top-0 left-0 h-full bg-white transition-all duration-100"
                             :style="'width:'+progress+'%'"></div>
                    </div>
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
    </div>





<div class="fixed top-5 right-5 z-[9999] space-y-3">
    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $toasts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $toast): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <!--[if BLOCK]><![endif]--><?php if($toast['type'] !== 'rate-limit'): ?>
            <div
                x-data="{
                    show:true,
                    progress:100
                }"
                x-init="
                    const d = <?php echo e($toast['duration'] ?? 4000); ?>;
                    const step = 100/(d/100);
                    const i = setInterval(()=>{progress-=step; if(progress<=0){show=false;clearInterval(i)}},100);
                    setTimeout(()=>show=false,d);
                "
                x-show="show"
                x-transition.opacity.duration.300ms
                class="relative flex items-start space-x-3 w-80 p-4 rounded-xl shadow-lg overflow-hidden
                    <?php if($toast['type']==='success'): ?> bg-green-500 text-white
                    <?php elseif($toast['type']==='error'): ?> bg-red-500 text-white
                    <?php elseif($toast['type']==='warning'): ?> bg-yellow-400 text-black
                    <?php else: ?> bg-gray-800 text-white <?php endif; ?>"
            >
                <div class="shrink-0">
                    <!--[if BLOCK]><![endif]--><?php switch($toast['type']):
                        case ('success'): ?> ✅ <?php break; ?>
                        <?php case ('error'): ?>   ❌ <?php break; ?>
                        <?php case ('warning'): ?> ⚠️ <?php break; ?>
                        <?php default: ?>         ℹ️
                    <?php endswitch; ?><!--[if ENDBLOCK]><![endif]-->
                </div>
                <div class="flex-1">
                    <p class="text-sm font-semibold"><?php echo e($toast['message']); ?></p>
                </div>
                <div class="absolute bottom-0 left-0 h-1 bg-white/30"
                     :style="'width:'+progress+'%'"></div>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
</div>

</div><?php /**PATH C:\laragon\www\Survey_Department\resources\views\livewire/core/advanced-toast.blade.php ENDPATH**/ ?>