<!DOCTYPE html>
<?php
    use Illuminate\Support\Str;
    $settings = Auth::user()?->settings ?? [];
    $dark = array_key_exists('dark_mode', $settings)
        ? json_encode($settings['dark_mode'])
        : 'localStorage.getItem("theme") === "dark"';

    $lang = array_key_exists('language', $settings) ? "'{$settings['language']}'" : "'" . app()->getLocale() . "'";

    // New meta variables and sensible fallbacks
    $siteUrl   = rtrim(config('app.url', url('/')), '/');
    $metaUrl   = url()->current();
    $metaTitle = $title ?? config('app.name', 'Orascom');
    $metaDesc  = $description ?? 'أوراسكوم قسم مساحة - منصة إدارة الموظفين.';
    $metaKeywords = $keywords ?? 'survey, orascom, surveys, data, analytics';
    $siteName     = config('app.name', 'Orascom');
    $twitterHandle = config('services.twitter.handle') ?? '@Orascom';

    // default images (ensure these exist in public/assets/img)
    $defaultOg1 = "https://sur.4tressro.com/assets/img/og-1200x630.jpg";
    $defaultOg2 = "https://sur.4tressro.com/assets/img/og-1200x1200.jpg";

    // image values may be provided per-page (controller/view)
    $ogImages = [
        ['url' => ($image ?? $defaultOg1), 'w' => ($imageWidth ?? 1200), 'h' => ($imageHeight ?? 630), 'alt' => ($imageAlt ?? $metaTitle)],
        ['url' => $defaultOg2, 'w' => 1200, 'h' => 1200, 'alt' => ($imageAlt ?? $metaTitle)],
    ];

    // optional verification / integration keys (set in config/services.php or .env)
    $fbAppId = config('services.facebook.app_id') ?? null;
    $googleVerification = config('services.google.site_verification') ?? null;
?>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" x-data="{
    darkMode: <?php echo e($dark); ?>,

    toggleTheme() {
        this.darkMode = !this.darkMode;
        localStorage.setItem('theme', this.darkMode ? 'dark' : 'light');
        <?php if(Auth::check()): ?> fetch('<?php echo e(route('update.darkmode', ['id' => Auth::id()])); ?>'); <?php endif; ?>
    },
    locale: <?php echo e($lang); ?>,
    switchLang() {
        const target = this.locale === 'ar' ? 'en' : 'ar';
        this.locale = target;
        document.documentElement.setAttribute('dir', target === 'ar' ? 'rtl' : 'ltr');
        window.location.href = '<?php echo e(url('set-language')); ?>/' + target;
    }
}" x-init="$watch('darkMode', val => localStorage.setItem('theme', val ? 'dark' : 'light'));
document.documentElement.setAttribute('dir', locale === 'ar' ? 'rtl' : 'ltr');"
    x-bind:class="{ 'dark': darkMode }" class="transition duration-500">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />

    <title><?php echo e($metaTitle); ?></title>

    <!-- Primary SEO -->
    <meta name="description" content="<?php echo e($metaDesc); ?>">
    <meta name="keywords" content="<?php echo e($metaKeywords); ?>">
    <meta name="author" content="<?php echo e($siteName); ?>">
    <meta name="robots" content="index, follow">
    <link rel="canonical" href="<?php echo e($metaUrl); ?>">

    <!-- Open Graph / Facebook -->
    <meta property="og:title" content="<?php echo e($metaTitle); ?>">
    <meta property="og:description" content="<?php echo e($metaDesc); ?>">
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo e($metaUrl); ?>">
    <meta property="og:site_name" content="<?php echo e($siteName); ?>">
    <meta property="og:locale" content="<?php echo e(app()->getLocale() === 'ar' ? 'ar_AR' : 'en_US'); ?>">

    <!-- Multiple images with explicit sizes -->
<?php $__currentLoopData = $ogImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
  <meta property="og:image" content="<?php echo e($img['url']); ?>">
  <meta property="og:image:secure_url" content="<?php echo e(preg_replace('#^http://#','https://',$img['url'])); ?>">
  <meta property="og:image:width" content="<?php echo e($img['w']); ?>">
  <meta property="og:image:height" content="<?php echo e($img['h']); ?>">
  <meta property="og:image:type" content="image/jpeg">
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:site" content="<?php echo e($twitterHandle); ?>">
    <meta name="twitter:creator" content="<?php echo e($twitterHandle); ?>">
    <meta name="twitter:title" content="<?php echo e($metaTitle); ?>">
    <meta name="twitter:description" content="<?php echo e($metaDesc); ?>">
    <meta name="twitter:image" content="<?php echo e($ogImages[0]['url']); ?>">
    <meta name="twitter:image:alt" content="<?php echo e($ogImages[0]['alt']); ?>">

    <!-- Mobile / PWA theming -->
    <meta name="theme-color" content="#0f172a">
    <meta name="msapplication-TileColor" content="#0f172a">
    <meta name="apple-mobile-web-app-capable" content="yes">

    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600" rel="stylesheet" />

    <!-- hreflang / alternates for multilingual sites -->
    <link rel="alternate" href="<?php echo e($metaUrl); ?>" hreflang="<?php echo e(app()->getLocale()); ?>" />
    <link rel="alternate" href="<?php echo e($siteUrl); ?>" hreflang="x-default" />
    <link rel="alternate" href="<?php echo e($siteUrl); ?>/ar" hreflang="ar" />
    <link rel="alternate" href="<?php echo e($siteUrl); ?>/en" hreflang="en" />

    <?php if($googleVerification): ?>
        <meta name="google-site-verification" content="<?php echo e($googleVerification); ?>">
    <?php endif; ?>

    <?php if($fbAppId): ?>
        <meta property="fb:app_id" content="<?php echo e($fbAppId); ?>">
    <?php endif; ?>

    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/frontend/app.css', 'resources/js/app.js']); ?>


    <!-- JSON-LD structured data (WebSite + Organization + WebPage) -->
    <script type="application/ld+json">
        <?php echo json_encode([
            "@context" => "https://schema.org",
            "@type" => "WebSite",
            "url" => $siteUrl,
            "name" => $siteName,
            "potentialAction" => [
                "@type" => "SearchAction",
                "target" => $siteUrl . "/?s={search_term_string}",
                "query-input" => "required name=search_term_string"
            ]
        ], JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE); ?>

    </script>

    <script type="application/ld+json">
        <?php echo json_encode([
            "@context" => "https://schema.org",
            "@type" => "Organization",
            "url" => $siteUrl,
            "name" => $siteName,
            "logo" => [
                "@type" => "ImageObject",
                "url" => $ogImages[0]['url'],
                "width" => $ogImages[0]['w'],
                "height" => $ogImages[0]['h']
            ]
        ], JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE); ?>

    </script>

    <script type="application/ld+json">
        <?php echo json_encode([
            "@context" => "https://schema.org",
            "@type" => "WebPage",
            "url" => $metaUrl,
            "name" => $metaTitle,
            "description" => $metaDesc,
            "inLanguage" => app()->getLocale(),
            "mainEntityOfPage" => [
                "@type" => "WebSite",
                "@id" => $siteUrl
            ],
            "image" => [
                [
                    "@type" => "ImageObject",
                    "url" => $ogImages[0]['url'],
                    "width" => $ogImages[0]['w'],
                    "height" => $ogImages[0]['h']
                ]
            ]
        ], JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE); ?>

    </script>


    <?php if(Auth::check()): ?>
        <script>
            localStorage.setItem('theme', <?php echo e($dark); ?>);
            // localStorage.setItem('lang', <?php echo e($lang !== 'null' ? $lang : '"' . app()->getLocale() . '"'); ?>);
            localStorage.setItem('lang', "<?php echo e($lang !== 'null' ? $lang : app()->getLocale()); ?>");
        </script>
    <?php endif; ?>
</head>

<?php /**PATH C:\laragon\www\Survey_Department\resources\views/components/frontend/layouts/struct/head.blade.php ENDPATH**/ ?>