<?php

use App\Models\User;
use App\Models\User\UserEmployee;
use App\Models\User\UserProject;
use Illuminate\Auth\Events\Registered;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;
use Livewire\Attributes\Layout;
use Livewire\Volt\Component;
use Livewire\WithFileUploads;
use Illuminate\View\View;
use Livewire\Features\SupportFileUploads\TemporaryUploadedFile as LivewireTemp;
use Illuminate\Validation\Rules\Password;
use Illuminate\Support\Facades\Storage;

?>

<!-- ───────────────────────────── View ───────────────────────────── -->
<div x-data="{ showTerms: false, uploading: false, uploadProgress: 0, uploadError: null }"
    class="min-h-screen flex items-center justify-center bg-transparent transition duration-700 overflow-hidden relative">

    <!-- Loader عام للفورم (مُحسّن، يظهر في منتصف الشاشة أثناء أي Livewire request) -->
    <div wire:loading.delay.long
        class="absolute inset-0 bg-white/60 dark:bg-zinc-900/70 backdrop-blur-sm flex items-center justify-center z-50 pointer-events-auto">
        <div class="flex flex-col items-center gap-4 p-6 bg-white dark:bg-zinc-900/95 rounded-xl shadow-2xl border border-zinc-200 dark:border-zinc-700 animate-fade-in">
            <img src="/assets/img/logo.png" alt="logo" class="w-20 h-auto" />

            <div class="flex items-center gap-4">
                <svg class="w-12 h-12 text-indigo-600 animate-spin" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                    <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v4a4 4 0 00-4 4H4z"></path>
                </svg>

                <div class="text-left">
                    <div class="text-lg font-semibold text-zinc-800 dark:text-white"><?php echo e(__('frontend.processing') ?? 'Processing'); ?></div>
                    <div class="text-sm text-zinc-600 dark:text-zinc-300"><?php echo e(__('frontend.pleasewait') ?? 'Please wait — this may take a few seconds.'); ?></div>
                </div>
            </div>
        </div>
    </div>

    <!-- Register form wrapper -->
    <div
        class="z-10 max-w-md w-full space-y-6 bg-white/80 dark:bg-zinc-900/80 backdrop-blur-md p-8 rounded-xl shadow-2xl border border-zinc-300 dark:border-zinc-700">
        <div class="flex flex-col items-center gap-2 animate-fade-in-down">
            <img src="/assets/img/logo.png" alt="Logo" class="w-[300px] h-auto mb-3 drop-shadow-lg" />
            <h2 class="text-2xl font-semibold text-zinc-800 dark:text-white"><?php echo e(__('frontend.createaccount')); ?></h2>
        </div>

        <form wire:submit.prevent="register" class="space-y-3 animate-fade-in-down">



            <!-- Step Section with Pulse (3 Steps) -->
            <div class="mb-6 space-y-2">

                <!-- Step Label -->
                <div class="flex justify-center items-center mb-2">
                    <span class="text-sm font-semibold text-zinc-700 dark:text-zinc-300">
                        <?php echo e(__('frontend.step')); ?> <?php echo e($currentStep); ?> <?php echo e(__('frontend.of')); ?> 3
                    </span>
                </div>

                <!-- Steps Indicators -->
                <div class="flex justify-center items-center space-x-2 rtl:space-x-reverse mb-2">
                    <template x-for="step in 3" :key="step">
                        <div class="flex items-center justify-center w-8 h-8 rounded-full border-2 font-semibold transition-all duration-300 text-sm relative"
                            :class="{
                                'bg-indigo-600 text-white border-indigo-600 shadow-lg animate-pulse-step': $wire
                                    .currentStep === step,
                                'bg-white text-zinc-700 dark:bg-zinc-800 dark:text-zinc-300 border-zinc-300 dark:border-zinc-600': $wire
                                    .currentStep !== step
                            }">
                            <span x-text="step"></span>
                        </div>
                    </template>
                </div>

                <!-- Progress Bar -->
                <div class="w-full bg-zinc-200 rounded-full h-2.5 dark:bg-zinc-700">
                    <div class="bg-indigo-600 h-2.5 rounded-full transition-all duration-500"
                        :style="{ width: (($wire.currentStep - 1) / (3 - 1)) * 100 + '%' }">
                    </div>
                </div>

            </div>


            <div x-show="$wire.currentStep === 1">
                <!-- Full name EN -->
                <div>
                    <label for="name" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                        <?php echo e(__('frontend.fullname')); ?>

                    </label>
                    <input type="text" id="name" required placeholder="Michael"
                        class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition"
                        wire:model.defer="name" />
                </div>

                <!-- Full name AR -->
                <div>
                    <label for="name_ar" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                        <?php echo e(__('frontend.fullname')); ?> (عربي)
                    </label>
                    <input type="text" id="name_ar" required placeholder="مايكل"
                        class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition"
                        wire:model.defer="name_ar" />
                </div>


                <!-- Email -->
                <div>
                    <label for="email" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                        <?php echo e(__('frontend.emailadress')); ?>

                    </label>
                    <div
                        class="flex rounded-lg overflow-hidden border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 focus-within:ring-2 focus-within:ring-indigo-500 transition-all duration-300">
                        <div
                            class="flex items-center px-3 bg-zinc-100 dark:bg-zinc-700 border-r border-zinc-300 dark:border-zinc-600 text-indigo-500 dark:text-indigo-400">
                            <!-- email icon -->
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2"
                                viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M4 4h16v16H4z" stroke="none" />
                                <polyline points="22,6 12,13 2,6" />
                            </svg>
                        </div>
                        <input type="email" id="email" required placeholder="example@email.com"
                            class="flex-1 px-4 py-2 text-zinc-900 dark:text-white bg-transparent outline-none"
                            wire:model.defer="email" />
                    </div>
                </div>

                <!-- Phone Number -->
                <div x-data="{
                    phones: <?php if ((object) ('phone') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('phone'->value()); ?>')<?php echo e('phone'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('phone'); ?>')<?php endif; ?>,
                    addPhone() {
                        this.phones.push('');
                    },
                    removePhone(index) {
                        if (this.phones.length > 1) {
                            this.phones.splice(index, 1);
                        }
                    }
                }">
                    <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                        <?php echo e(__('frontend.phone')); ?>

                    </label>

                    <template x-for="(phone, index) in phones" :key="index">
                        <div class="flex items-center gap-2 mb-2">
                            <div
                                class="flex items-center gap-2 px-3 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 flex-1">
                                <!-- Icon + Prefix -->
                                <svg class="w-5 h-5 text-indigo-500 dark:text-indigo-400" fill="none"
                                    stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round"
                                    stroke-linejoin="round">
                                    <path
                                        d="M22 16.92V21a2 2 0 0 1-2.18 2A19.79 19.79 0 0 1 3 5.18 2 2 0 0 1 5 3h4.09a1 1 0 0 1 1 .75l1.21 4.84a1 1 0 0 1-.29 1L9.1 11.1a16 16 0 0 0 6.9 6.9l1.51-1.51a1 1 0 0 1 1-.29l4.84 1.21a1 1 0 0 1 .75 1z" />
                                </svg>
                                <span class="text-sm font-medium select-none">+20</span>
                                <input type="tel" :id="'phone_' + index" placeholder="10xxxxxxxx"
                                    class="flex-1 px-2 py-1 bg-transparent outline-none text-zinc-900 dark:text-white"
                                    x-model="phones[index]" />
                            </div>

                            <!-- زر الحذف -->
                            <button type="button" @click="removePhone(index)"
                                class="text-red-500 hover:text-red-700 text-lg font-bold px-2 py-1">
                                &times;
                            </button>
                        </div>
                    </template>

                    <!-- زر إضافة رقم -->
                    <div class="flex justify-center mt-2">
                        <button type="button" @click="addPhone()"
                            class="px-3 py-1 bg-indigo-600 text-white text-sm rounded hover:bg-indigo-700 transition">
                            + <?php echo e(__('frontend.add_phone')); ?>

                        </button>
                    </div>

                    <p class="mt-1 text-xs text-zinc-500 dark:text-zinc-400">
                        <?php echo e(__('frontend.phone_hint')); ?>

                    </p>
                </div>



                <!-- Password -->
                <div>
                    <label for="password" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                        <?php echo e(__('frontend.password')); ?>

                    </label>
                    <div
                        class="flex rounded-lg overflow-hidden border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 focus-within:ring-2 focus-within:ring-indigo-500 transition-all duration-300">
                        <div
                            class="flex items-center px-3 bg-zinc-100 dark:bg-zinc-700 border-r border-zinc-300 dark:border-zinc-600 text-indigo-500 dark:text-indigo-400">
                            <!-- lock icon -->
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2"
                                viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round">
                                <rect x="3" y="11" width="18" height="11" rx="2" ry="2" />
                                <path d="M7 11V7a5 5 0 0110 0v4" />
                            </svg>
                        </div>
                        <input type="password" id="password" required placeholder="••••••••"
                            class="flex-1 px-4 py-2 text-zinc-900 dark:text-white bg-transparent outline-none"
                            wire:model.defer="password" />
                    </div>
                </div>

                <!-- Confirm Password -->
                <div>
                    <label for="password_confirmation"
                        class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                        <?php echo e(__('frontend.confirmpassword')); ?>

                    </label>
                    <div
                        class="flex rounded-lg overflow-hidden border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 focus-within:ring-2 focus-within:ring-indigo-500 transition-all duration-300">
                        <div
                            class="flex items-center px-3 bg-zinc-100 dark:bg-zinc-700 border-r border-zinc-300 dark:border-zinc-600 text-indigo-500 dark:text-indigo-400">
                            <!-- lock icon -->
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2"
                                viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round">
                                <rect x="3" y="11" width="18" height="11" rx="2" ry="2" />
                                <path d="M7 11V7a5 5 0 0110 0v4" />
                            </svg>
                        </div>
                        <input type="password" id="password_confirmation" required placeholder="••••••••"
                            class="flex-1 px-4 py-2 text-zinc-900 dark:text-white bg-transparent outline-none"
                            wire:model.defer="password_confirmation" />
                    </div>
                </div>
                <div class="flex justify-between mt-6 space-x-2 rtl:space-x-reverse">
                    <!-- Previous Button -->
                    <button type="button" wire:click="previousStep" x-show="$wire.currentStep > 1"
                        x-transition.opacity.duration.300ms x-transition.scale.duration.300ms
                        class="px-5 py-2 bg-gray-200 dark:bg-zinc-700 text-gray-700 dark:text-white font-medium rounded-lg hover:bg-gray-300 dark:hover:bg-zinc-600 transition-all duration-300">
                        ← <?php echo e(__('frontend.previous')); ?>

                    </button>

                    <!-- Next Button -->
                    <button type="button" wire:click="nextStep" x-show="$wire.currentStep < 3"
                        x-transition.opacity.duration.300ms x-transition.scale.duration.300ms
                        wire:loading.attr="disabled" wire:target="nextStep"
                        :class="$wire.currentStep < 3 ? '' : 'hidden'"
                        class="px-5 py-2 bg-indigo-600 text-white font-medium rounded-lg hover:bg-indigo-700 transition-all duration-300">
                        <span wire:loading.remove wire:target="nextStep"><?php echo e(__('frontend.next')); ?> →</span>
                        <span wire:loading wire:target="nextStep"><?php echo e(__('frontend.pleasewait_short') ?? 'Waiting...'); ?></span>
                    </button>

                    <!-- Submit Button -->
                    <button type="submit" x-show="$wire.currentStep === 3" x-transition.opacity.duration.300ms
                        x-transition.scale.duration.300ms
                        :disabled="uploading"
                        :class="uploading ? 'opacity-60 cursor-not-allowed' : ''"
                        class="px-5 py-2 bg-green-600 text-white font-medium rounded-lg hover:bg-green-700 transition-all duration-300">
                        🚀 <?php echo e(__('frontend.submit')); ?>

                    </button>
                </div>
            </div>

            <div x-show="$wire.currentStep === 2">
                <!-- National ID -->
                <div>
                    <label for="national_id" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                        <?php echo e(__('frontend.national_id')); ?>

                    </label>
                    <div
                        class="flex rounded-lg overflow-hidden border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 focus-within:ring-2 focus-within:ring-indigo-500 transition-all duration-300">
                        <div
                            class="flex items-center px-3 bg-zinc-100 dark:bg-zinc-700 border-r border-zinc-300 dark:border-zinc-600 text-indigo-500 dark:text-indigo-400">
                            <!-- id icon -->
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2"
                                viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M16 21v-2a4 4 0 00-8 0v2" />
                                <circle cx="12" cy="7" r="4" />
                                <rect x="2" y="3" width="20" height="18" rx="2" ry="2" />
                            </svg>
                        </div>
                        <input type="text" id="national_id" maxlength="14" required placeholder="xxxxxxxxxxxxxx"
                            class="flex-1 px-4 py-2 text-zinc-900 dark:text-white bg-transparent outline-none"
                            wire:model.defer="national_id" />
                    </div>
                </div>
                <!-- Project -->
                <div>
                    <label for="project_code" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                        <?php echo e(__('frontend.project')); ?>

                    </label>
                    <div
                        class="flex rounded-lg overflow-hidden border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 focus-within:ring-2 focus-within:ring-indigo-500 transition-all duration-300">
                        <div
                            class="flex items-center px-3 bg-zinc-100 dark:bg-zinc-700 border-r border-zinc-300 dark:border-zinc-600 text-indigo-500 dark:text-indigo-400">
                            <!-- project icon -->
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2"
                                viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M21 16V8a2 2 0 0 0-2-2H5a2 2 0 0 0-2 2v8" />
                                <rect x="7" y="12" width="3" height="6" />
                                <rect x="14" y="12" width="3" height="6" />
                                <path d="M12 12V4" />
                            </svg>
                        </div>
                        <select id="project_code" wire:model.defer="project_code"
                            class="flex-1 px-4 py-2 bg-transparent text-zinc-900 dark:text-white outline-none appearance-none">
                            <option value=""><?php echo e(__('frontend.chooseproject')); ?></option>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = UserProject::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($project->code); ?>"><?php echo e($project->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </select>
                    </div>
                </div>

                <!-- Hire Date -->
                <div>
                    <label for="hire_date" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                        <?php echo e(__('frontend.hire_date')); ?>

                    </label>
                    <input type="date" id="hire_date" required
                        class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition"
                        wire:model.defer="hire_date" />
                </div>

                <!-- Job Title -->
                <div>
                    <label for="job_title_id" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                        <?php echo e(__('frontend.job_title')); ?>

                    </label>
                    <div
                        class="flex rounded-lg overflow-hidden border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 focus-within:ring-2 focus-within:ring-indigo-500 transition-all duration-300">
                        <div
                            class="flex items-center px-3 bg-zinc-100 dark:bg-zinc-700 border-r border-zinc-300 dark:border-zinc-600 text-indigo-500 dark:text-indigo-400">
                            <!-- briefcase icon -->
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2"
                                viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round">
                                <rect x="2" y="7" width="20" height="14" rx="2" ry="2">
                                </rect>
                                <path d="M16 3h-8a2 2 0 0 0-2 2v2h12V5a2 2 0 0 0-2-2z"></path>
                            </svg>
                        </div>
                        <select id="job_title_id" wire:model.defer="job_title_id" required
                            class="flex-1 px-4 py-2 bg-transparent text-zinc-900 dark:text-white outline-none appearance-none">
                            <option value=""><?php echo e(__('frontend.choosejobtitle')); ?></option>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = App\Models\User\UserJobTitle::whereNotIn('id', [1, 2, 3])->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $jobTitle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($jobTitle->id); ?>">
                                    <?php echo e(app()->getLocale() == 'ar' ? $jobTitle->title_ar : $jobTitle->title_en); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </select>
                    </div>
                </div>

                <div class="flex justify-between mt-6 space-x-2 rtl:space-x-reverse">
                    <!-- Previous Button -->
                    <button type="button" wire:click="previousStep" x-show="$wire.currentStep > 1"
                        x-transition.opacity.duration.300ms x-transition.scale.duration.300ms
                        class="px-5 py-2 bg-gray-200 dark:bg-zinc-700 text-gray-700 dark:text-white font-medium rounded-lg hover:bg-gray-300 dark:hover:bg-zinc-600 transition-all duration-300">
                        ← <?php echo e(__('frontend.previous')); ?>

                    </button>

                    <!-- Next Button -->
                    <button type="button" wire:click="nextStep" x-show="$wire.currentStep < 3"
                        x-transition.opacity.duration.300ms x-transition.scale.duration.300ms
                        wire:loading.attr="disabled" wire:target="nextStep"
                        :class="$wire.currentStep < 3 ? '' : 'hidden'"
                        class="px-5 py-2 bg-indigo-600 text-white font-medium rounded-lg hover:bg-indigo-700 transition-all duration-300">
                        <span wire:loading.remove wire:target="nextStep"><?php echo e(__('frontend.next')); ?> →</span>
                        <span wire:loading wire:target="nextStep"><?php echo e(__('frontend.pleasewait_short') ?? 'Waiting...'); ?></span>
                    </button>

                    <!-- Submit Button -->
                    <button type="submit" x-show="$wire.currentStep === 3" x-transition.opacity.duration.300ms
                        x-transition.scale.duration.300ms
                        :disabled="uploading"
                        :class="uploading ? 'opacity-60 cursor-not-allowed' : ''"
                        class="px-5 py-2 bg-green-600 text-white font-medium rounded-lg hover:bg-green-700 transition-all duration-300">
                        🚀 <?php echo e(__('frontend.submit')); ?>

                    </button>
                </div>
            </div>

            <div x-show="$wire.currentStep === 3">

                <h2 class="text-2xl font-bold text-zinc-800 dark:text-white mb-6 text-center">
                    📝 <?php echo e(__('frontend.cv_section_title')); ?> <!-- ترجم في lang/ar -->
                </h2>

                <!-- Profile Picture Upload (resilient with progress) -->
                <div class="mb-6" x-data>
                    <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-2">
                        <?php echo e(__('frontend.upload_profile_picture')); ?>

                    </label>

                    <div class="flex flex-col items-center justify-center border-2 border-dashed border-zinc-300 dark:border-zinc-600 rounded-lg p-4 cursor-pointer hover:bg-zinc-50 dark:hover:bg-zinc-800 transition"
                        @click="$refs.profilePicture.click()"
                        x-on:livewire-upload-start="uploading = true; uploadProgress = 0; uploadError = null"
                        x-on:livewire-upload-finish="uploading = false; uploadProgress = 100"
                        x-on:livewire-upload-error="uploading = false; uploadError = 'Upload failed, try again.'"
                        x-on:livewire-upload-progress="uploadProgress = $event.detail.progress">

                        <svg class="w-10 h-10 text-indigo-500 mb-2" fill="none" stroke="currentColor"
                            stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M12 5v14M5 12h14" />
                        </svg>
                        <span class="text-sm text-zinc-500 dark:text-zinc-400">
                            <?php echo e(__('frontend.click_to_upload_picture')); ?>

                        </span>

                        <input type="file" x-ref="profilePicture" wire:model.live="profile_picture"
                            class="hidden" accept="image/jpeg,image/png,image/jpg" />
                    </div>

                    <!-- Progress / status -->
                    <div class="mt-3 space-y-2">
                        <template x-if="uploading">
                            <div class="w-full">
                                <div class="text-xs text-zinc-600 dark:text-zinc-300 mb-1"><?php echo e(__('frontend.uploading')); ?> — <span x-text="uploadProgress + '%'">0%</span></div>
                                <div class="w-full bg-zinc-200 h-2 rounded-full overflow-hidden">
                                    <div class="h-2 bg-indigo-600 transition-all" :style="`width: ${uploadProgress}%`"></div>
                                </div>

                                <div class="flex justify-end mt-2">
                                    <button type="button" class="text-sm px-3 py-1 bg-zinc-100 dark:bg-zinc-700 rounded text-zinc-700 dark:text-white"
                                        @click.prevent="uploading=false; uploadProgress=0; $refs.profilePicture.value = ''; $wire.set('profile_picture', null);">
                                        <?php echo e(__('frontend.cancel_upload')); ?>

                                    </button>
                                </div>
                            </div>
                        </template>

                        <template x-if="!uploading">
                            <div>
                                <!--[if BLOCK]><![endif]--><?php if(!empty($profile_picture)): ?>
                                    <div class="mt-3">
                                        <img src="<?php echo e($profile_picture->temporaryUrl()); ?>"
                                            class="w-24 h-24 object-cover rounded-full border border-zinc-300 dark:border-zinc-600 mx-auto" />
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <div class="text-xs text-red-600 mt-1" x-text="uploadError" x-show="uploadError"></div>
                            </div>
                        </template>
                    </div>
                </div>

                <!-- Work Experience Section -->
                <div x-data="{
                    activeTab: 'roads',
                    experience_roads: <?php if ((object) ('experience_roads') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('experience_roads'->value()); ?>')<?php echo e('experience_roads'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('experience_roads'); ?>')<?php endif; ?>,
                    experience_airports: <?php if ((object) ('experience_airports') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('experience_airports'->value()); ?>')<?php echo e('experience_airports'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('experience_airports'); ?>')<?php endif; ?>,
                    addProject(tab) {
                        if (tab === 'roads') {
                            this.experience_roads = [...this.experience_roads, {
                                name: '',
                                start_date: '',
                                end_date: '',
                                description: ''
                            }];
                        } else {
                            this.experience_airports = [...this.experience_airports, {
                                name: '',
                                start_date: '',
                                end_date: '',
                                description: ''
                            }];
                        }
                    },

                    removeProject(tab, index) {
                        if (tab === 'roads') {
                            this.experience_roads.splice(index, 1);
                        } else {
                            this.experience_airports.splice(index, 1);
                        }
                    }

                }" class="space-y-4">

                    <h3 class="text-lg font-semibold text-zinc-700 dark:text-zinc-300 mb-2">
                        <?php echo e(__('frontend.work_experience')); ?>

                    </h3>

                    <!-- Tabs -->
                    <div class="flex space-x-2 mb-4">
                        <button type="button" @click="activeTab = 'roads'"
                            :class="activeTab === 'roads' ? 'bg-indigo-600 text-white' :
                                'bg-zinc-200 dark:bg-zinc-700 text-zinc-700 dark:text-zinc-300'"
                            class="px-4 py-2 rounded-lg font-medium transition">
                            <?php echo e(__('frontend.roads')); ?>

                        </button>
                        <button type="button" @click="activeTab = 'airports'"
                            :class="activeTab === 'airports' ? 'bg-indigo-600 text-white' :
                                'bg-zinc-200 dark:bg-zinc-700 text-zinc-700 dark:text-zinc-300'"
                            class="px-4 py-2 rounded-lg font-medium transition">
                            <?php echo e(__('frontend.airports')); ?>

                        </button>
                    </div>

                    <!-- Projects List -->
                    <template
                        x-for="(project, index) in activeTab === 'roads' ? experience_roads : experience_airports"
                        :key="index">
                        <div
                            class="space-y-2 p-4 border border-zinc-300 dark:border-zinc-600 rounded-lg bg-white dark:bg-zinc-800 relative">

                            <!-- Remove button -->
                            <button type="button" @click="removeProject(activeTab, index)"
                                class="absolute top-1 ltr:right-1 rtl:left-1 bg-red-600 hover:bg-red-700 text-white text-xs w-5 h-5 rounded-full shadow-md z-10 transition-transform transform hover:scale-110">
                                ×
                            </button>


                            <!-- Project Name -->
                            <div>
                                <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                                    <?php echo e(__('frontend.project_name')); ?>

                                </label>
                                <input type="text" x-model="project.name"
                                    class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition"
                                    placeholder="<?php echo e(__('frontend.project_name_placeholder')); ?>" />
                            </div>

                            <!-- Start Date -->
                            <div>
                                <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                                    <?php echo e(__('frontend.start_date')); ?>

                                </label>
                                <input type="date" x-model="project.start_date"
                                    class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition" />
                            </div>

                            <!-- End Date -->
                            <div>
                                <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                                    <?php echo e(__('frontend.end_date')); ?>

                                </label>
                                <input type="date" x-model="project.end_date"
                                    class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition" />
                            </div>

                            <!-- Project Description -->
                            <div>
                                <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                                    <?php echo e(__('frontend.project_description')); ?>

                                </label>
                                <textarea x-model="project.description"
                                    class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition"
                                    placeholder="<?php echo e(__('frontend.project_description_placeholder')); ?>"></textarea>
                            </div>

                        </div>
                    </template>

                    <!-- Add Project Button -->
                    <div class="flex justify-center mt-4">
                        <button type="button" @click="addProject(activeTab)"
                            class="px-4 py-2 bg-indigo-600 text-white rounded-lg hover:bg-indigo-700 transition">
                            <?php echo e(__('frontend.add_project')); ?>

                        </button>
                    </div>
                </div>

                <!-- Skills Input -->
                <div x-data="{
                    newSkill: '',
                    skills: <?php if ((object) ('skills') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('skills'->value()); ?>')<?php echo e('skills'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('skills'); ?>')<?php endif; ?>,
                    addSkill() {
                        if (this.newSkill.trim() !== '' && !this.skills.includes(this.newSkill.trim())) {
                            this.skills.push(this.newSkill.trim());
                            this.newSkill = '';
                        }
                    },
                    removeSkill(index) {
                        this.skills.splice(index, 1);
                    }
                }">
                    <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                        <?php echo e(__('frontend.skills')); ?>

                    </label>

                    <div class="flex gap-2 mb-2">
                        <input type="text" x-model="newSkill"
                            class="flex-1 px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition"
                            placeholder="<?php echo e(__('frontend.skills_placeholder')); ?>"
                            @keydown.enter.prevent="addSkill" />
                        <button type="button" @click="addSkill"
                            class="px-4 py-2 bg-indigo-600 text-white rounded-lg hover:bg-indigo-700 transition">
                            +
                        </button>
                    </div>

                    <!-- Skills List -->
                    <div class="flex flex-wrap gap-2">
                        <template x-for="(skill, index) in skills" :key="index">
                            <div
                                class="flex items-center bg-indigo-100 text-indigo-800 px-3 py-1 rounded-full text-sm font-medium">
                                <span x-text="skill"></span>
                                <button type="button" @click="removeSkill(index)"
                                    class="ml-2 text-indigo-500 hover:text-indigo-700">&times;</button>
                            </div>
                        </template>
                    </div>
                </div>

                <!-- ID Card Images Upload -->
                <!-- Drag & Drop + Input file -->
                <div x-data="{
                    dragging: false,
                    handleDrop(e) {
                        this.dragging = false;

                        let files = Array.from(e.dataTransfer.files);

                        // إرسال الملفات يدويًا إلى Livewire
                        $wire.uploadMultiple('id_card_images', files,
                            () => {}, // success
                            () => {} // error
                        );
                    }
                }" x-on:dragover.prevent="dragging = true"
                    x-on:dragleave.prevent="dragging = false" x-on:drop.prevent="handleDrop($event)"
                    class="relative border-2 border-dashed rounded-lg p-6 flex flex-col items-center justify-center transition duration-300"
                    :class="{
                        'border-indigo-500 bg-indigo-50': dragging,
                        'border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800':
                            !dragging
                    }">

                    <!-- Label -->
                    <div class="mb-2">
                        <label class="block text-sm font-semibold text-zinc-700 dark:text-zinc-300">
                            <?php echo e(__('frontend.attach_documents')); ?>

                        </label>
                        <p class="text-xs text-zinc-500 dark:text-zinc-400 mt-1">
                            <?php echo e(__('frontend.required_documents_hint')); ?>

                        </p>
                        <ul class="list-disc list-inside text-xs text-zinc-500 dark:text-zinc-400 mt-1 space-y-1">
                            <li><?php echo e(__('frontend.document_id_card')); ?></li>
                            <li><?php echo e(__('frontend.document_national_id')); ?></li>
                            <li><?php echo e(__('frontend.document_work_experience_certificates')); ?></li>
                        </ul>
                    </div>

                    <p class="text-sm text-zinc-500 dark:text-zinc-400 mb-2 text-center">
                        <?php echo e(__('frontend.drag_here_or')); ?>

                    </p>

                    <label for="id_card_images"
                        class="cursor-pointer bg-indigo-600 text-white text-sm px-4 py-2 rounded-md hover:bg-indigo-700 transition">
                        <?php echo e(__('frontend.choose_files')); ?>

                        <input type="file" id="id_card_images" multiple wire:model.live="id_card_images"
                            class="hidden" accept="image/*,application/pdf" />

                    </label>

                </div>

                <!--[if BLOCK]><![endif]--><?php if(!empty($id_card_images)): ?>
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $id_card_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div
                            class="relative group w-[120px] h-[120px] flex flex-col items-center justify-center border border-zinc-300 dark:border-zinc-600 rounded-lg bg-white dark:bg-zinc-800 shadow-sm overflow-hidden">

                            <!-- زر الحذف -->
                            <button wire:click.prevent="removeImage(<?php echo e($index); ?>)"
                                class="absolute top-1 right-1 bg-red-600 hover:bg-red-700 text-white text-xs w-5 h-5 rounded-full shadow-md z-10">
                                ×
                            </button>

                            <!--[if BLOCK]><![endif]--><?php if(Str::endsWith($file->getClientOriginalName(), '.pdf')): ?>
                                <div class="flex flex-col items-center justify-center px-2 text-center">
                                    <div class="text-3xl">📄</div>
                                    <span class="text-[10px] text-zinc-600 dark:text-zinc-300 truncate w-[90%]">
                                        <?php echo e(Str::limit($file->getClientOriginalName(), 14)); ?>

                                    </span>
                                </div>
                            <?php else: ?>
                                <div
                                    class="w-[100px] h-[100px] overflow-hidden rounded-md border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800">
                                    <img src="<?php echo e($file->temporaryUrl()); ?>" class="w-full h-full object-cover" />
                                </div>
                                <span class="text-[10px] text-zinc-600 dark:text-zinc-300 truncate w-[90%] mt-1">
                                    <?php echo e(Str::limit($file->getClientOriginalName(), 14)); ?>

                                </span>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->






                <!-- Agree & open modal -->
                <label class="inline-flex items-center cursor-pointer group" @click.prevent="showTerms=true">
                    <input type="checkbox" class="sr-only" wire:model.defer="agreed">
                    <div class="w-5 h-5 border-2 border-zinc-400 dark:border-zinc-600 bg-white dark:bg-zinc-800 rounded-md flex items-center justify-center transition-colors duration-300"
                        :class="{ 'bg-indigo-500 border-indigo-500': $wire.agreed }">
                        <svg class="w-3 h-3 transition-opacity duration-300 text-zinc-800 dark:text-white"
                            :class="{ 'opacity-100': $wire.agreed, 'opacity-0': !$wire.agreed }"
                            xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                            stroke="currentColor" stroke-width="3">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7" />
                        </svg>
                    </div>
                    <span
                        class="ml-3 text-sm text-zinc-700 dark:text-zinc-300 select-none transition-colors duration-300"><?php echo e(__('frontend.agree')); ?>

                        <span class="underline text-blue-600"><?php echo e(__('frontend.terms')); ?></span></span>
                </label>

                <div class="flex justify-between mt-6 space-x-2 rtl:space-x-reverse">
                    <!-- Previous Button -->
                    <button type="button" wire:click="previousStep" x-show="$wire.currentStep > 1"
                        x-transition.opacity.duration.300ms x-transition.scale.duration.300ms
                        class="px-5 py-2 bg-gray-200 dark:bg-zinc-700 text-gray-700 dark:text-white font-medium rounded-lg hover:bg-gray-300 dark:hover:bg-zinc-600 transition-all duration-300">
                        ← <?php echo e(__('frontend.previous')); ?>

                    </button>



                    <!-- Submit Button -->
                    <button type="submit" x-show="$wire.currentStep === 3" x-transition.opacity.duration.300ms
                        x-transition.scale.duration.300ms
                        :disabled="uploading"
                        :class="uploading ? 'opacity-60 cursor-not-allowed' : ''"
                        class="px-5 py-2 bg-green-600 text-white font-medium rounded-lg hover:bg-green-700 transition-all duration-300">
                        🚀 <?php echo e(__('frontend.submit')); ?>

                    </button>
                </div>
                
            </div>

        </form>

        <!-- Already have account -->
        <div class="text-center mt-4 animate-fade-in-down">
            <p class="text-sm text-zinc-600 dark:text-zinc-300"><?php echo e(__('frontend.alreadyhave')); ?> <a
                    href="<?php echo e(route('login')); ?>" class="text-blue-500 hover:underline"><?php echo e(__('frontend.login')); ?></a>
            </p>
        </div>
    </div>

    <!-- ======= Modal ======= -->
    <div x-show="showTerms" x-transition.opacity
        class="fixed inset-0 bg-black/60 backdrop-blur-sm flex items-center justify-center z-50" x-cloak>
        <div x-transition.scale
            class="bg-white dark:bg-zinc-900 rounded-xl shadow-lg w-[90%] max-w-lg p-6 space-y-4 border border-zinc-200 dark:border-zinc-700 overflow-y-auto max-h-[80vh]">
            <div class="flex flex-col items-center justify-center text-center space-y-2"><img
                    src="/assets/img/logo.png" class="h-12 w-auto" alt="logo">
                <h3 class="text-lg font-semibold text-zinc-800 dark:text-white"><?php echo e(__('frontend.terms')); ?></h3>
            </div>
            <ul class="list-disc ps-6 text-sm text-zinc-700 dark:text-zinc-300 space-y-1">
                <li><?php echo __('frontend.term_item1'); ?></li>
                <li><?php echo __('frontend.term_item2'); ?></li>
                <li><?php echo __('frontend.term_item3'); ?></li>
                <li><?php echo __('frontend.term_item4'); ?></li>
                <li><?php echo __('frontend.term_item5'); ?></li>
            </ul>
            <div class="flex justify-end gap-3 pt-4">
                <button @click="$wire.set('agreed', false); showTerms=false"
                    class="px-4 py-2 rounded-lg text-sm bg-zinc-200 dark:bg-zinc-700 hover:bg-zinc-300 dark:hover:bg-zinc-600"><?php echo e(__('frontend.cancel')); ?></button>
                <button @click="$wire.set('agreed', true); showTerms=false"
                    class="px-4 py-2 rounded-lg text-sm bg-indigo-600 text-white hover:bg-indigo-700"><?php echo e(__('frontend.agree')); ?></button>
            </div>
            <a href="<?php echo e(route('terms.print')); ?>" target="_blank"
                class="block text-sm text-blue-600 hover:underline text-center mt-4"><?php echo e(__('frontend.view_full_terms')); ?></a>
        </div>
    </div>
</div><?php /**PATH C:\laragon\www\Survey_Department\resources\views\livewire/frontend/auth/register.blade.php ENDPATH**/ ?>