<?php

use App\Http\Controllers\Auth\VerifyEmailController;
use Illuminate\Support\Facades\Route;
use Livewire\Volt\Volt;

Route::middleware('guest')->group(function () {
    Volt::route('login', 'frontend.auth.login')
        ->name('login');

    Volt::route('register', 'frontend.auth.register')
        ->name('register');

    Volt::route('forgot-password', 'frontend.auth.forgot-password')
        ->name('password.request');

    Volt::route('reset-password/{token}', 'frontend.auth.reset-password')
        ->name('password.reset');
});

Route::middleware('auth')->group(function () {
    Volt::route('inactive', 'backend.auth.activate-inactive')
    ->name('activate.inactive');

    Volt::route('blocked', 'backend.auth.activate-block')
    ->name('activate.block');

    Volt::route('rejected', 'backend.auth.activate-rejected')
    ->name('activate.rejected');

    Volt::route('suspended', 'backend.auth.activate-suspended')
    ->name('activate.suspended');

    Volt::route('two-factor', 'backend.auth.activate-two-factor')
    ->name('activate-two-factor');

    Volt::route('verify-email', 'backend.auth.verify-email')
        ->name('verification.notice');

    Route::get('verify-email/{id}/{hash}', VerifyEmailController::class)
        ->middleware(['signed', 'throttle:6,1'])
        ->name('verification.verify');

    Volt::route('confirm-password', 'backend.auth.confirm-password')
        ->name('password.confirm');

        Volt::route('two-factor-verify', 'backend.auth.two-factor-verify')
        ->middleware(['has-two-factor'])
        ->name('two-factor-verify');

    Volt::route('lock', 'backend.auth.lock-screen')
    ->name('lock.screen');

    Volt::route('profile', 'backend.user.profile')
    ->name('user-profile');

    Volt::route('mails', 'backend.mail.page')
    ->name('mails-setting');

    Volt::route('users', 'backend.user.page')
    ->name('users-table');

});

Route::post('logout', App\Livewire\Actions\Logout::class)
    ->name('logout');
