<x-frontend.layouts.struct :title="__('backend.department_name') . ' | ' . __('frontend.Home')" :maxWidth="'7xl'">
    <div x-data="{
        text: '{{ __('frontend.welcome') }}',
        displayedText: '',
        charIndex: 0,
        typingSpeed: 80,
        showLogo: false,
        showDesc: false,
        showButtons: false,
        showCursor: true,
    }" x-init="const typingInterval = setInterval(() => {
        if (charIndex < text.length) {
            displayedText += text[charIndex++];
        } else {
            clearInterval(typingInterval);
            setTimeout(() => showLogo = true, 400);
            setTimeout(() => showDesc = true, 1000);
            setTimeout(() => showButtons = true, 1600);
            setTimeout(() => showCursor = false, 2200);
        }
    }, typingSpeed);" class="z-10 text-center p-6 space-y-6">

        <!-- 👋 Text Animation -->
        <div class="relative inline-block">
            <h2 class="text-4xl sm:text-5xl font-bold text-zinc-800 dark:text-white inline-block relative">
                <span x-text="displayedText"></span>

                <!-- ✨ Cursor Glow Effect -->
                <template x-if="showCursor">
                    <span x-transition:leave="transition ease-in duration-500"
                        x-transition:leave-start="opacity-100 scale-100"
                        x-transition:leave-end="opacity-0 scale-95 blur-sm"
                        class="inline-block animate-glow-cursor text-indigo-400 text-6xl font-bold animate-pulse-fast">
                        |
                    </span>
                </template>

            </h2>
        </div>

        <!-- 🌐 Logo -->
        <div x-show="showLogo" x-transition.scale.duration.1000ms>
            <img src="assets/img/logo.png" alt="Logo"
                class="mx-auto w-full max-w-[500px] h-auto rounded-xl shadow-2xl border-4 dark:border-white border-zinc-300 bg-white/30 backdrop-blur-lg p-4">
        </div>

        <!-- 💬 Description -->
        <div x-show="showDesc" x-transition.opacity.duration.800ms>
            <p class="text-lg sm:text-xl text-zinc-600 dark:text-zinc-300">
                {{ __('frontend.desc') }}
            </p>
        </div>

        <!-- 🔐 CTA Buttons -->
        <div x-show="showButtons" x-transition.opacity.duration.1000ms
            class="flex justify-center gap-5 mt-10 flex-wrap">
            <a href="/login" class="neon-btn delay-[1000ms] neon-blue">
                <span class="btn-text">{{ __('frontend.login') }}</span>
                <span class="glow"></span>
            </a>
            <a href="/register" class="neon-btn delay-[1300ms] neon-green">
                <span class="btn-text">{{ __('frontend.register') }}</span>
                <span class="glow"></span>
            </a>
        </div>
        <!-- ➕ Add CV Button -->
        {{-- <div x-show="showButtons" x-transition.opacity.duration.1200ms class="flex justify-center mt-6">
            <a href="/cv" class="neon-btn delay-[1300ms] neon-purple">
                <span class="btn-text">{{ __('frontend.add_cv') }}</span>
                <span class="glow"></span>
            </a>
        </div> --}}

    </div>





</x-frontend.layouts.struct>
