<?php

use Livewire\Volt\Component;
use Livewire\Attributes\On;

new class extends Component
{
    /** @var array<array{ id:string, type:string, message:string, duration:int, countdown:int }> */
    public array $toasts = [];

    #[On('notify')]
    public function addToast(
        string $type = 'info',
        string $message = '',
        int    $duration = 4000,
        int    $countdown = 0,
    ): void {
        $this->toasts[] = [
            'id'       => uniqid('toast_'),
            'type'     => $type,
            'message'  => $message,
            'duration' => $duration,
            'countdown' => $countdown,
        ];

        $this->dispatch('toast-added', type: $type);
    }


    #[On('rate-finished')]
public function enableLogin(): void
{
    $this->loginDisabled = false;
}


  /* ---------- mount ---------- */

  public function mount(): void
    {
        if ($toast = session('toast')) {

            $this->dispatch(
                'notify',
                type:      $toast['type']      ?? 'info',
                message:   $toast['msg']       ?? ($toast['message'] ?? ''),
                duration:  $toast['duration']  ?? 4000,
                countdown: $toast['countdown'] ?? 0,
            );
        }
    }
};


?>
<div>
    {{-- RATE LIMIT TOAST CENTER SCREEN --}}
    <div class="fixed top-1/2 left-1/2 z-[9999] -translate-x-1/2 -translate-y-1/2">
        @foreach ($toasts as $toast)
            @if($toast['type'] === 'rate-limit')
                <div
                    x-data="{
                        show:true,
                        remaining: {{ $toast['countdown'] }},
                        progress:100
                    }"
                    x-init="
                        const total = remaining;
                        const t = setInterval(() => {
                            remaining--;
                            progress = (remaining/total)*100;
                            if (remaining<=0) {
                                clearInterval(t);
                                show = false;
                                Livewire.dispatch('rate-finished');
                            }
                        },1000);
                    "
                    x-show="show"
                    x-transition.opacity.duration.300ms
                    class="w-[360px] bg-red-800/95 text-white p-6 rounded-3xl shadow-2xl text-center space-y-5 animate-fade-in"
                >
                    {{-- Warning Icon --}}
                    <div class="w-12 h-12 border-2 border-white rounded-full flex items-center justify-center bg-red-500/50 shadow-inner animate-pulse mx-auto">
                        {{-- <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.054 0 1.658-1.14 1.105-2.05L13.105 4.05c-.527-.89-1.843-.89-2.37 0L3.977 16.95C3.423 17.86 4.027 19 5.082 19z" />
                        </svg> --}}
                        <div class="text-4xl animate-spin transition duration-[10000ms]">⏳</div>
                    </div>

                    {{-- Countdown + Hourglass --}}
                    <div class="flex items-center justify-center gap-3">
                        <div class="text-5xl font-extrabold tracking-widest drop-shadow" x-text="remaining">0</div>
                    </div>

                    {{-- Message --}}
                    <div class="text-sm font-medium text-white/90">
                        {{ __('auth.throttle') }}
                    </div>

                    {{-- Progress Bar --}}
                    <div class="relative w-full h-2 bg-white/20 rounded overflow-hidden">
                        <div class="absolute top-0 left-0 h-full bg-white transition-all duration-100"
                             :style="'width:'+progress+'%'"></div>
                    </div>
                </div>
            @endif
        @endforeach
    </div>




{{-- REGULAR TOASTS TOP-RIGHT --}}
<div class="fixed top-5 right-5 z-[9999] space-y-3">
    @foreach ($toasts as $toast)
        @if($toast['type'] !== 'rate-limit')
            <div
                x-data="{
                    show:true,
                    progress:100
                }"
                x-init="
                    const d = {{ $toast['duration'] ?? 4000 }};
                    const step = 100/(d/100);
                    const i = setInterval(()=>{progress-=step; if(progress<=0){show=false;clearInterval(i)}},100);
                    setTimeout(()=>show=false,d);
                "
                x-show="show"
                x-transition.opacity.duration.300ms
                class="relative flex items-start space-x-3 w-80 p-4 rounded-xl shadow-lg overflow-hidden
                    @if($toast['type']==='success') bg-green-500 text-white
                    @elseif($toast['type']==='error') bg-red-500 text-white
                    @elseif($toast['type']==='warning') bg-yellow-400 text-black
                    @else bg-gray-800 text-white @endif"
            >
                <div class="shrink-0">
                    @switch($toast['type'])
                        @case('success') ✅ @break
                        @case('error')   ❌ @break
                        @case('warning') ⚠️ @break
                        @default         ℹ️
                    @endswitch
                </div>
                <div class="flex-1">
                    <p class="text-sm font-semibold">{{ $toast['message'] }}</p>
                </div>
                <div class="absolute bottom-0 left-0 h-1 bg-white/30"
                     :style="'width:'+progress+'%'"></div>
            </div>
        @endif
    @endforeach
</div>

</div>
