@if ($activeModal === 'deleteProject')
<div x-data="{ show: true }"
     x-show="show"
     x-transition:enter="transition ease-out duration-300"
     x-transition:enter-start="opacity-0 scale-95"
     x-transition:enter-end="opacity-100 scale-100"
     x-transition:leave="transition ease-in duration-200"
     x-transition:leave-start="opacity-100 scale-100"
     x-transition:leave-end="opacity-0 scale-90"
     class="fixed inset-0 z-50 bg-black/50 flex items-center justify-center"
     @click.away="show = false; $wire.closeModal()">

    <div class="bg-white dark:bg-zinc-900 w-full max-w-md p-6 rounded-lg shadow-xl border border-zinc-300 dark:border-zinc-700">
        <h3 class="text-lg font-semibold text-zinc-800 dark:text-white mb-4">
            {{ __('backend.confirm_delete') }}
        </h3>
        <p class="text-sm text-zinc-700 dark:text-zinc-300 mb-6">
            {{ __('backend.confirm_delete_message') }}
            <br>
            <span class="font-semibold text-red-600 dark:text-red-400">
                {{ $selectedProject['name'] ?? '-' }} - [
                {{ $selectedProject['code'] ?? '-' }}
                ]
            </span>
        </p>

        <div class="flex justify-end gap-2">
            <button @click="show = false; $wire.closeModal()"
                class="px-4 py-2 text-sm rounded bg-gray-200 dark:bg-zinc-700 text-zinc-800 dark:text-white hover:bg-gray-300 dark:hover:bg-zinc-600">
                {{ __('backend.cancel') }}
            </button>
            <button wire:click="deleteConfirmed"
                class="px-4 py-2 text-sm rounded bg-red-600 hover:bg-red-700 text-white">
                {{ __('backend.confirm_delete') }}
            </button>
        </div>
    </div>
</div>
@endif
