<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
    <meta charset="UTF-8">
    <title>{{ __('Employees List') }}</title>
    <style>
        @page {
            size: A4 landscape;
            margin: 1.5cm;
        }
        body {
            font-family: 'DejaVu Sans', sans-serif;
            margin: 0;
            padding: 0;
            color: #000;
            background: #fff;
            font-size: 12px;
            counter-reset: page;
        }
        header, footer {
            position: fixed;
            left: 0;
            right: 0;
            text-align: center;
            font-size: 12px;
        }
        header {
            top: 0;
            height: 100px;
        }
        footer {
            bottom: 0;
            height: 30px;
            font-size: 10px;
            color: #555;
        }
        main {
            margin-top: 120px;
            margin-bottom: 50px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 1rem;
        }
        th, td {
            border: 1px solid #999;
            padding: 8px;
            text-align: center;
        }
        thead {
            background-color: #f2f2f2;
        }
        tr:nth-child(even) {
            background-color: #fbfbfb;
        }
        .pagenum:before {
            content: counter(page);
        }
    </style>
</head>

<body onload="window.print()">

<header>
    {{-- شعار الشركة --}}
    <img src="{{ public_path('images/logo.png') }}" alt="Logo" style="height: 60px; margin-bottom: 5px;">
    {{-- العنوان --}}
    <h1 style="margin: 0;">{{ __('Employees List') }}</h1>
</header>

<footer>
    {{ __('Page') }} <span class="pagenum"></span>
</footer>

<main>
    <table>
        <thead>
            <tr>
                <th>{{ __('Employee Code') }}</th>
                <th>{{ __('Full Name') }}</th>
                <th>{{ __('Department') }}</th>
                <th>{{ __('Job Title') }}</th>
                <th>{{ __('Project') }}</th>
                <th>{{ __('Gender') }}</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($employees as $emp)
                <tr>
                    <td>{{ $emp->employee_code }}</td>
                    <td>{{ $emp->full_name['ar'] ?? '—' }}</td>
                    <td>{{ $emp->department?->name_ar ?? '—' }}</td>
                    <td>{{ $emp->jobTitle?->name_ar ?? '—' }}</td>
                    <td>{{ $emp->project?->name_ar ?? '—' }}</td>
                    <td>{{ $emp->gender === 'male' ? __('Male') : __('Female') }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</main>

</body>
</html>
