<div x-show="$wire.currentStep === 1">
    <!-- CV Code Input Box -->
    <div class="mb-6">

        <!-- Full name EN -->
        <div>
            <label for="name" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                {{ __('frontend.fullname') }}
            </label>
            <input type="text" id="name" required placeholder="Michael Daniel"
                class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition"
                wire:model.defer="editcv.name" />
        </div>


    </div>


    <!-- Full name AR -->
    <div>
        <label for="name_ar" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
            {{ __('frontend.fullname') }} (عربي)
        </label>
        <input type="text" id="name_ar" required placeholder="مايكل"
            class="block w-full px-4 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 text-zinc-900 dark:text-white focus:ring-2 focus:ring-indigo-500 outline-none transition"
            wire:model.defer="editcv.name_ar" />
    </div>





    <!-- Email -->
    <div>
        <label for="email" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
            {{ __('frontend.emailadress') }}
            <span class="text-xs text-zinc-500 dark:text-zinc-400">({{ __('frontend.optional') }})</span>
        </label>
        <div
            class="flex rounded-lg overflow-hidden border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 focus-within:ring-2 focus-within:ring-indigo-500 transition-all duration-300">
            <div
                class="flex items-center px-3 bg-zinc-100 dark:bg-zinc-700 border-r border-zinc-300 dark:border-zinc-600 text-indigo-500 dark:text-indigo-400">
                <!-- email icon -->
                <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"
                    stroke-linecap="round" stroke-linejoin="round">
                    <path d="M4 4h16v16H4z" stroke="none" />
                    <polyline points="22,6 12,13 2,6" />
                </svg>
            </div>
            <input type="email" id="email" placeholder="example@email.com"
                class="flex-1 px-4 py-2 text-zinc-900 dark:text-white bg-transparent outline-none"
                wire:model.defer="editcv.email" />
        </div>
    </div>

    <!-- Phone Number -->
    <div x-data="{
        phones: @entangle('editcv.phone'),
        addPhone() {
            this.phones.push('');
        },
        removePhone(index) {
            if (this.phones.length > 1) {
                this.phones.splice(index, 1);
            }
        }
    }">
        <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
            {{ __('frontend.phone') }}
        </label>

        <template x-for="(phone, index) in phones" :key="index">
            <div class="flex items-center gap-2 mb-2">
                <div
                    class="flex items-center gap-2 px-3 py-2 rounded-lg border border-zinc-300 dark:border-zinc-600 bg-white dark:bg-zinc-800 flex-1">
                    <!-- Icon + Prefix -->
                    <svg class="w-5 h-5 text-indigo-500 dark:text-indigo-400" fill="none" stroke="currentColor"
                        stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round">
                        <path
                            d="M22 16.92V21a2 2 0 0 1-2.18 2A19.79 19.79 0 0 1 3 5.18 2 2 0 0 1 5 3h4.09a1 1 0 0 1 1 .75l1.21 4.84a1 1 0 0 1-.29 1L9.1 11.1a16 16 0 0 0 6.9 6.9l1.51-1.51a1 1 0 0 1 1-.29l4.84 1.21a1 1 0 0 1 .75 1z" />
                    </svg>
                    <span class="text-sm font-medium select-none">+20</span>
                    <input type="tel" :id="'phone_' + index" placeholder="10xxxxxxxx"
                        class="flex-1 px-2 py-1 bg-transparent outline-none text-zinc-900 dark:text-white"
                        x-model="phones[index]" />
                </div>

                <!-- زر الحذف -->
                <button type="button" @click="removePhone(index)"
                    class="text-red-500 hover:text-red-700 text-lg font-bold px-2 py-1">
                    &times;
                </button>
            </div>
        </template>

        <!-- زر إضافة رقم -->
        <div class="flex justify-center mt-2">
            <button type="button" @click="addPhone()"
                class="px-3 py-1 bg-indigo-600 text-white text-sm rounded hover:bg-indigo-700 transition">
                + {{ __('frontend.add_phone') }}
            </button>
        </div>

        <p class="mt-1 text-xs text-zinc-500 dark:text-zinc-400">
            {{ __('frontend.phone_hint') }}
        </p>
    </div>


</div>
