<!-- resources/views/livewire/backend/user/modals/employee-movement-modal.blade.php -->
<div
    x-data="{
        show: true,
        type: @entangle('type'),
        openEnded: @entangle('openEnded'),
        applyNow: @entangle('applyNow')
    }"
    x-cloak
    x-show="show"
    @keydown.escape.window="show = false; $wire.closeModal()"
    @click.away="show = false; $wire.closeModal()"
    class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-4"
>
    <div class="bg-white dark:bg-zinc-900 rounded-2xl shadow-xl w-full max-w-lg p-6 space-y-6 overflow-y-auto max-h-[90vh] transition-all">

        <!-- Header -->
        <div class="flex justify-between items-center mb-4">
            <h3 class="text-xl font-semibold text-zinc-800 dark:text-white">
                {{ __('backend.add_employee_movement') }}
            </h3>
            <button
                @click="show = false; $wire.closeModal()"
                class="text-zinc-500 hover:text-zinc-800 dark:hover:text-white text-2xl leading-none transition-colors"
            >&times;</button>
        </div>

        <!-- Form -->
        <form wire:submit.prevent="saveMovement" class="space-y-6">

            <!-- 1. نوع الحركة -->
            <div
                x-transition:enter="transition ease-out duration-300"
                x-transition:enter-start="opacity-0 -translate-y-2"
                x-transition:enter-end="opacity-100 translate-y-0"
                x-transition:leave="transition ease-in duration-200"
                x-transition:leave-start="opacity-100 translate-y-0"
                x-transition:leave-end="opacity-0 -translate-y-2"
            >
                <label for="type" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300">
                    {{ __('backend.movement_type') }}
                </label>
                <select
                    id="type"
                    wire:model="type"
                    class="mt-1 block w-full rounded-lg border border-gray-300 dark:border-zinc-700 bg-white dark:bg-zinc-800
                           px-3 py-2 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-green-500 transition-colors"
                >
                    <option value="">{{ __('backend.select_type') }}</option>
                    <option value="mission">{{ __('backend.mission') }}</option>
                    <option value="transfer">{{ __('backend.title_transfer') }}</option>
                    <option value="termination">{{ __('backend.termination') }}</option>
                </select>
                @error('type') <span class="text-red-600 text-sm">{{ $message }}</span> @enderror
            </div>

            <!-- 1.1 تنفيذ الآن -->
            <template x-if="type !== ''">
                <div
                    x-cloak
                    x-transition:enter="transition ease-out duration-300"
                    x-transition:enter-start="opacity-0 -translate-y-2"
                    x-transition:enter-end="opacity-100 translate-y-0"
                    x-transition:leave="transition ease-in duration-200"
                    x-transition:leave-start="opacity-100 translate-y-0"
                    x-transition:leave-end="opacity-0 -translate-y-2"
                >
                    <label class="flex items-center space-x-2 rtl:space-x-reverse text-sm text-zinc-700 dark:text-zinc-300">
                        <input
                            type="checkbox"
                            wire:model.defer="applyNow"
                            class="form-checkbox h-5 w-5 text-green-600 focus:ring-green-500 transition-colors"
                        >
                        {{ __('backend.apply_now') }}
                    </label>
                </div>
            </template>

            <!-- 2. تاريخ البداية -->
            <div
                x-show="type !== '' && !applyNow" x-cloak
                x-transition:enter="transition ease-out duration-300"
                x-transition:enter-start="opacity-0 -translate-y-2"
                x-transition:enter-end="opacity-100 translate-y-0"
                x-transition:leave="transition ease-in duration-200"
                x-transition:leave-start="opacity-100 translate-y-0"
                x-transition:leave-end="opacity-0 -translate-y-2"
            >
                <label for="start_date" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300">
                    {{ __('backend.start_date') }}
                </label>
                <input
                    type="date"
                    id="start_date"
                    wire:model.defer="start_date"
                    class="mt-1 block w-full rounded-lg border border-gray-300 dark:border-zinc-700 bg-white dark:bg-zinc-800
                           px-3 py-2 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-green-500 transition-colors"
                >
                @error('start_date') <span class="text-red-600 text-sm">{{ $message }}</span> @enderror
            </div>

            <!-- 3. تاريخ النهاية لمأمورية -->
            <template x-if="type === 'mission'">
                <div
                    x-cloak
                    x-transition:enter="transition ease-out duration-300"
                    x-transition:enter-start="opacity-0 -translate-y-2"
                    x-transition:enter-end="opacity-100 translate-y-0"
                    x-transition:leave="transition ease-in duration-200"
                    x-transition:leave-start="opacity-100 translate-y-0"
                    x-transition:leave-end="opacity-0 -translate-y-2"
                    class="space-y-2"
                >
                    <label class="flex items-center space-x-2 rtl:space-x-reverse text-sm text-zinc-700 dark:text-zinc-300">
                        <input
                            type="checkbox"
                            wire:model.defer="openEnded"
                            class="form-checkbox h-5 w-5 text-green-600 focus:ring-green-500 transition-colors"
                        >
                        {{ __('backend.open_ended') }}
                    </label>

                    <div x-show="!openEnded" class="pt-1" x-cloak>
                        <label for="end_date" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300">
                            {{ __('backend.end_date') }}
                        </label>
                        <input
                            type="date"
                            id="end_date"
                            wire:model.defer="end_date"
                            class="mt-1 block w-full rounded-lg border border-gray-300 dark:border-zinc-700 bg-white dark:bg-zinc-800
                                   px-3 py-2 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-green-500 transition-colors"
                        >
                        @error('end_date') <span class="text-red-600 text-sm">{{ $message }}</span> @enderror
                    </div>
                </div>
            </template>

            <!-- 4. اختيار المشروع الوجهة -->
            <div
                x-show="type === 'mission' || type === 'transfer'" x-cloak
                x-transition:enter="transition ease-out duration-300"
                x-transition:enter-start="opacity-0 -translate-y-2"
                x-transition:enter-end="opacity-100 translate-y-0"
                x-transition:leave="transition ease-in duration-200"
                x-transition:leave-start="opacity-100 translate-y-0"
                x-transition:leave-end="opacity-0 -translate-y-2"
            >
                <label for="to_project" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300">
                    {{ __('backend.to_project') }}
                </label>
                <select
                    id="to_project"
                    wire:model.defer="to_project"
                    class="mt-1 block w-full rounded-lg border border-gray-300 dark:border-zinc-700 bg-white dark:bg-zinc-800
                           px-3 py-2 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-green-500 transition-colors"
                >
                    <option value="">{{ __('backend.select_project') }}</option>
                    @foreach($projects as $proj)
                        <option value="{{ $proj['id'] }}">{{ $proj['name'] }}</option>
                    @endforeach
                </select>
                @error('to_project') <span class="text-red-600 text-sm">{{ $message }}</span> @enderror
            </div>

            <!-- 5. الملاحظات -->
            <div
                x-transition:enter="transition ease-out duration-300"
                x-transition:enter-start="opacity-0 -translate-y-2"
                x-transition:enter-end="opacity-100 translate-y-0"
                x-transition:leave="transition ease-in duration-200"
                x-transition:leave-start="opacity-100 translate-y-0"
                x-transition:leave-end="opacity-0 -translate-y-2"
            >
                <label for="notes" class="block text-sm font-medium text-zinc-700 dark:text-zinc-300">
                    {{ __('backend.notes') }}
                </label>
                <textarea
                    id="notes"
                    rows="4"
                    wire:model.defer="notes"
                    class="mt-1 block w-full rounded-lg border border-gray-300 dark;border-zinc-700 bg-white dark:bg-zinc-800
                           px-3 py-2 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-green-500 transition-colors"
                ></textarea>
                @error('notes') <span class="text-red-600 text-sm">{{ $message }}</span> @enderror
            </div>

            <!-- Footer Buttons -->
            <div class="pt-6 flex justify-end space-x-2 rtl:space-x-reverse">
                <button
                    type="button"
                    @click="show = false; $wire.closeModal()"
                    class="px-4 py-2 rounded-lg text-sm font-medium bg-zinc-200 dark:bg-zinc-700 hover:bg-zinc-300 dark:hover:bg-zinc-600
                           focus:outline-none focus:ring-2 focus:ring-zinc-500 transition-colors"
                >
                    {{ __('backend.cancel') }}
                </button>
                <button
                    type="submit"
                    class="px-4 py-2 rounded-lg text-sm font-medium bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-green-500
                           text-white transition-colors"
                >
                    {{ __('backend.save') }}
                </button>
            </div>

        </form>

    </div>
</div>
