<!-- resources/views/livewire/backend/employee/modals/add-new.blade.php -->

<div x-data="{ show: true }"
    x-show="show"
    x-transition:enter="transition ease-out duration-300"
    x-transition:enter-start="opacity-0 scale-90"
    x-transition:enter-end="opacity-100 scale-100"
    x-transition:leave="transition ease-in duration-200"
    x-transition:leave-start="opacity-100 scale-100"
    x-transition:leave-end="opacity-0 scale-90"
    @click.away="$wire.closeModal()"
    class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 px-4 sm:px-6 lg:px-8">

    <div
        class="bg-white dark:bg-zinc-900 rounded-xl shadow-2xl border border-zinc-200 dark:border-zinc-700 w-full max-w-4xl p-6 space-y-6 transition-all duration-300 overflow-y-auto max-h-[90vh]">

        <!-- Header -->
        <div class="flex justify-between items-center mb-4 sticky top-0 bg-white dark:bg-zinc-900 z-10 pb-2 border-b border-zinc-200 dark:border-zinc-700">
            <h3 class="text-xl font-bold text-zinc-800 dark:text-white">
                📝 {{ __('backend.add_new_emp') }}
            </h3>
            <button @click="show = false; $wire.closeModal()"
                class="text-zinc-500 hover:text-zinc-800 dark:hover:text-white text-2xl leading-none">
                &times;
            </button>
        </div>

        <!-- Form Steps -->
        <form wire:submit.prevent="storeEmp" class="space-y-6">

            <!-- Step Indicator -->
            <div class="flex items-center justify-center gap-2 mb-6">
                <template x-for="step in 3" :key="step">
                    <div :class="{
                            'w-8 h-8 flex items-center justify-center rounded-full text-sm font-bold border transition-all': true,
                            'bg-indigo-600 text-white border-indigo-600': $wire.currentStep >= step,
                            'bg-gray-200 dark:bg-zinc-700 text-gray-600 dark:text-zinc-300 border-zinc-400 dark:border-zinc-600': $wire.currentStep < step
                        }">
                        <span x-text="step"></span>
                    </div>
                </template>
            </div>

            <!-- Steps Content -->
            @include('livewire.backend.employee.modals.partials.emp-step-1')
            @include('livewire.backend.employee.modals.partials.emp-step-2')
            @include('livewire.backend.employee.modals.partials.emp-step-3')

            <!-- Actions -->
            <div class="flex justify-between mt-6 space-x-2 rtl:space-x-reverse">

                <!-- Previous Button -->
                <button type="button" wire:click="previousStep" x-show="$wire.currentStep > 1"
                    x-transition.opacity.duration.300ms x-transition.scale.duration.300ms
                    class="px-5 py-2 bg-gray-200 dark:bg-zinc-700 text-gray-700 dark:text-white font-medium rounded-lg hover:bg-gray-300 dark:hover:bg-zinc-600 transition-all duration-300">
                    ← {{ __('frontend.previous') }}
                </button>

                <!-- Next Button -->
                <button type="button" wire:click="nextStep" x-show="$wire.currentStep < 3"
                    x-transition.opacity.duration.300ms x-transition.scale.duration.300ms
                    class="px-5 py-2 bg-indigo-600 text-white font-medium rounded-lg hover:bg-indigo-700 transition-all duration-300">
                    {{ __('frontend.next') }} →
                </button>

                <!-- Submit Button -->
                <button type="submit" x-show="$wire.currentStep === 3" x-transition.opacity.duration.300ms
                    x-transition.scale.duration.300ms
                    class="px-5 py-2 bg-green-600 text-white font-medium rounded-lg hover:bg-green-700 transition-all duration-300">
                    🚀 {{ __('frontend.submit') }}
                </button>
            </div>

        </form>
    </div>
</div>
