<div x-data="{ show: true }" x-show="show && $wire.activeModal[0] === 'edit'" x-cloak
    x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 scale-90"
    x-transition:enter-end="opacity-100 scale-100" x-transition:leave="transition ease-in duration-200"
    x-transition:leave-start="opacity-100 scale-100" x-transition:leave-end="opacity-0 scale-90"
    @keydown.escape.window="show = false; $wire.closeModal()" @click.away="show = false; $wire.closeModal()"
    class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 px-4 sm:px-6 lg:px-8">
    <div
        class="bg-white dark:bg-zinc-900 rounded-xl shadow-2xl border border-zinc-200 dark:border-zinc-700 w-full max-w-md p-6 space-y-4">
        <!-- Header -->
        <div class="flex justify-between items-center">
            <h3 class="text-xl font-semibold text-zinc-800 dark:text-white">
                {{ __('backend.edit_cv_code') }}
            </h3>
            <button @click="show = false; $wire.closeModal()"
                class="text-zinc-500 hover:text-zinc-800 dark:hover:text-white">&times;</button>
        </div>

        <!-- Form -->
        <div class="space-y-4">
            <div class="mb-3">
                <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                    {{ __('backend.project_name') }}
                </label>

                @if ($canViewAll)
                    <select wire:model.defer="edit.project_code"
                        class="w-full rounded-lg bg-white dark:bg-zinc-800 border
                               border-zinc-300 dark:border-zinc-700 px-3 py-2 text-sm">
                        <option value="">{{ __('backend.select_project') }}</option>
                        @foreach ($projects as $p)
                            <option value="{{ $p['code'] }}">{{ $p['name'] }}</option>
                        @endforeach
                    </select>
                @else
                    <input type="hidden" wire:model="project_code">
                    <span class="text-sm text-zinc-600 dark:text-zinc-400">
                        {{ optional(
                             \App\Models\User\UserProject::where('code', $edit['project_code'] ?? null)->first()
                           )->name }}
                    </span>
                @endif

                @error('project_code')  <span class="text-red-600 text-xs">{{ $message }}</span> @enderror

            </div>
            <div>
                <label
                    class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">{{ __('backend.cv_code_code') }}</label>
                <input type="text" wire:model.defer="edit.code"
                    class="w-full px-3 py-2 border rounded-lg bg-white dark:bg-zinc-800 dark:border-zinc-700 text-sm"
                    placeholder="{{ __('backend.enter_code') }}" />
            </div>
            @error('code')          <span class="text-red-600 text-xs">{{ $message }}</span> @enderror
            <div>
                <label
                    class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">{{ __('backend.cv_code_name') }}</label>
                <input type="text" wire:model.defer="edit.name"
                    class="w-full px-3 py-2 border rounded-lg bg-white dark:bg-zinc-800 dark:border-zinc-700 text-sm"
                    placeholder="{{ __('backend.enter_name') }}" />
            </div>
            @error('name')          <span class="text-red-600 text-xs">{{ $message }}</span> @enderror
            <div class="flex items-center">
                <input id="used" type="checkbox" wire:model="used"
                    class="h-4 w-4 text-indigo-600 border-gray-300 rounded" />
                <label for="used"
                    class="ml-2 text-sm text-zinc-700 dark:text-zinc-300">{{ __('backend.cv_code_used') }}</label>
            </div>
        </div>

        <!-- Actions -->
        <div class="flex justify-end space-x-2 rtl:space-x-reverse">
            <button @click="show = false; $wire.closeModal()"
                class="px-4 py-2 rounded-lg text-sm bg-zinc-200 dark:bg-zinc-700 hover:bg-zinc-300 dark:hover:bg-zinc-600 text-zinc-800 dark:text-white">
                {{ __('backend.cancel') }}
            </button>
            <button wire:click="update"
                class="px-4 py-2 rounded-lg text-sm bg-yellow-500 text-white hover:bg-yellow-600">
                {{ __('backend.save') }}
            </button>
        </div>
    </div>
</div>
