<div
  x-data="{ show: true }"
  x-show="show && $wire.activeModal[0] === 'delete'"
  x-cloak
  x-transition:enter="transition ease-out duration-300"
  x-transition:enter-start="opacity-0 scale-90"
  x-transition:enter-end="opacity-100 scale-100"
  x-transition:leave="transition ease-in duration-200"
  x-transition:leave-start="opacity-100 scale-100"
  x-transition:leave-end="opacity-0 scale-90"
  @keydown.escape.window="show = false; $wire.closeModal()"
  @click.away="show = false; $wire.closeModal()"
  class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 px-4 sm:px-6 lg:px-8"
>
  <div class="bg-white dark:bg-zinc-900 rounded-xl shadow-2xl border border-zinc-200 dark:border-zinc-700 w-full max-w-md p-6 space-y-4">
    <!-- Header -->
    <div class="flex justify-between items-center">
      <h3 class="text-xl font-semibold text-zinc-800 dark:text-white">
        {{ __('backend.confirm_delete') }}
      </h3>
      <button @click="show = false; $wire.closeModal()" class="text-zinc-500 hover:text-zinc-800 dark:hover:text-white">&times;</button>
    </div>

    <!-- Body -->
    @php
      $code = App\Models\Emp\UserEmployeeCvCode::find($activeModal[1] ?? null);
    @endphp
    <p class="text-sm text-zinc-700 dark:text-zinc-300">
      {{ __('backend.delete_confirmation', ['name' => $code->name, 'code' => $code->code]) }}
    </p>

    <!-- Actions -->
    <div class="flex justify-end space-x-2 rtl:space-x-reverse">
      <button @click="show = false; $wire.closeModal()" class="px-4 py-2 rounded-lg text-sm bg-zinc-200 dark:bg-zinc-700 hover:bg-zinc-300 dark:hover:bg-zinc-600 text-zinc-800 dark:text-white">
        {{ __('backend.cancel') }}
      </button>
      <button wire:click="delete" class="px-4 py-2 rounded-lg text-sm bg-red-600 text-white hover:bg-red-700">
        {{ __('backend.delete') }}
      </button>
    </div>
  </div>
</div>
